#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(

    # check if it's already been run
    if [[ -f "$MODDIR/.compilerran" ]]; then

        # start logging if enabled
        echo `date`;
        echo " --- Compiler has already run and will not be run again ---"

    else

        # start logging if enabled
        echo `date`;
        echo " --- Starting TDP Compiler ---"

        # attempt to do a full jit compile of all packages without checking the package profile
        # this is for battery life improvment
        cmd package compile -a -f --check-prof false -m everything

        # attempt to do a full jit compile of all package layouts without checking the package profile
        # this is for battery life improvment
        cmd package compile -a -f --check-prof false --compile-layouts

        # the above may break some apps.  To undo it run: `cmd package compile -a -f -r install` in shell or adb shell

        # finishes optimizing all system pakages for speed
        cmd package bg-dexopt-job

        # make sure the already ran flag is set
        touch $MODDIR/.compilerran;

        echo `date`;
        echo " --- Ending TDP Compiler ---"

    fi;

    # if the uncompiler exists
    if [[ -f "$MODDIR/tdp-undocompile" ]]; then

        # undo the battery compilation
        cmd package compile -a -f -r install

        # now make sure the already ran flag is set
        touch $MODDIR/.compilerran;

        # and remove this uncompiler flag
        rm -f $MODDIR/tdp-undocompile;

    fi;

) &
