#!/system/bin/sh

# our module's directory
MODDIR=${0%/*}

# hold the log file
THELOG=$MODDIR/log.txt

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# clear the log file before anything else.  This happens every boot
> $THELOG;

(

    # export the moddir so we have access to it throughout
    export MODDIR;

    # check if the debug file exists
    if [[ -f "$MODDIR/tdp-debug" ]]; then

        # it does, so log everything in here
        exec > >(tee -a "$THELOG") 2>&1

    fi;

    # if we're tweaking the kernel
    if [[ -f "$MODDIR/tdp-kernel" ]]; then

        # include our kernel tweaks
        source $MODDIR/includes/kernel.sh

    fi;

    # if we're tweaking the settings
    if [[ -f "$MODDIR/tdp-settings" ]]; then

        # include our settings tweaks
        source $MODDIR/includes/settings.sh

    fi;

    # if we're disabling the analytics
    if [[ -f "$MODDIR/tdp-analytics" ]]; then

        # include our analytics disabler
        source $MODDIR/includes/analytics.sh

    fi;

    # if we're disabling the diagnostics
    if [[ -f "$MODDIR/tdp-diagnostics" ]]; then

        # include our diagnostics disabler
        source $MODDIR/includes/diagnostics.sh

    fi;

    # if we're disabling the adservices
    if [[ -f "$MODDIR/tdp-adservices" ]]; then

        # include our adservices disabler
        source $MODDIR/includes/adservices.sh

    fi;

    # if we're disabling the tracking
    if [[ -f "$MODDIR/tdp-tracking" ]]; then

        # include our tracking disabler
        source $MODDIR/includes/tracking.sh

    fi;

    # if we're running the compiler
    if [[ -f "$MODDIR/tdp-compiler" ]]; then

        # include our compilerr
        source $MODDIR/includes/compiler.sh

    fi;

)
