#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Compiler ---"

    # attempt to do a full jit compile of all packages without checking the package profile
    # this is for battery life improvment
    cmd package compile -a -f --check-prof false -m everything

    # attempt to do a full jit compile of all package payouts without checking the package profile
    # this is for battery life improvment
    cmd package compile -a -f --check-prof false --compile-layouts

    # the above may break some apps.  To undo it run: `cmd package compile -a -f -r install` in shell or adb shell

    # finishes optimizing all system pakages for speed
    cmd package bg-dexopt-job

    echo `date`;
    echo " --- Ending TDP Compiler ---"

) &

