#!/system/bin/sh

# our module's directory
MODDIR=${0%/*}

# hold the log file
THELOG=$MODDIR/log.txt

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# clear the log file before anything else
> $THELOG;

# check if the debug file exists
if [[ -f "$MODDIR/tdp-debug" ]]; then

    # it does, so log everything in here
    exec > >(tee -a "$THELOG") 2>&1

fi;

# if we're tweaking the kernel
if [[ -f "$MODDIR/tdp-kernel" ]]; then

    # include our kernel tweaks
    . $MODDIR/includes/kernel.sh

fi;

# if we're tweaking the settings
if [[ -f "$MODDIR/tdp-settings" ]]; then

    # include our settings tweaks
    . $MODDIR/includes/settings.sh

fi;

# if we're disabling the analytics
if [[ -f "$MODDIR/tdp-analytics" ]]; then

    # include our analytics disabler
    . $MODDIR/includes/analytics.sh

fi;

# if we're disabling the diagnostics
if [[ -f "$MODDIR/tdp-diagnostics" ]]; then

    # include our diagnostics disabler
    . $MODDIR/includes/diagnostics.sh

fi;

# if we're disabling the adservices
if [[ -f "$MODDIR/tdp-adservices" ]]; then

    # include our adservices disabler
    . $MODDIR/includes/adservices.sh

fi;

# if we're disabling the tracking
if [[ -f "$MODDIR/tdp-tracking" ]]; then

    # include our tracking disabler
    . $MODDIR/includes/tracking.sh

fi;
