# TDP Tweaks
## Details
* **Version:** 1.2.78
* **Platform API:** 31+
* **Android Version:** 12+
* **Magisk Version:** 24.2+
* **Source Code:** https://gitlab.com/kp-development/android/pixel-6/tdp-tweaks 

This is a Magisk module that attempts to modify some settings and tweak some services for better device performance, better battery management, and better privacy.

It modifies some system settings, and then attempts to disable analytics services, ad services, diagnostic services, and tracking services.  Due to the nature of these services, the disabler will run every 4 hours based on the time you last rebooted your device.

If there are packages you need to exclude from this, you can add them to your `/sdcard/Download/tdp-excludes` file; line by line; and they will be skipped.  There are no defaults, and we attempt to do this for every app installed on your device including system apps.

If you need help/support with this module, you will need to turn on debugging.  To do this, all you have to do is create a file in `/sdcard/Download/` called: `tdp-debug`.  The module will pick this up and start logging on it's next run.  If you need the log right away, reboot your device after creating it.

Everything except the kernel tweaks should work on any device on Android 12 and up, though I only have a Pixel 6 Pro, so I am only able to test them out on that.  Your mileage may very, but if you have something else, and it works on that, please make sure to let me know.

**NOTE:**  I cannot be held responsible for bricks, world takeovers, or nuclear warfare.  As such, installing this mod is completely on you.  If you do not want this, do not flash it.

## Requirements
* **Platform API:** 31+
* **Android Version:** 12+
* **Magisk Version:** 24.2+

## Install

1. Download the zip file, and open Magisk.
    * You can find it here: https://gitlab.com/kp-development/android/pixel-6/tdp-tweaks/-/releases/
2. Tap on Modules
3. Tap 'Install from storage' and browse to where you downloaded the zip file to.
4. Tap 'Ok'
5. Reboot
6. Sit back and enjoy your device

## Settings

There officially are no settings, because this is only a set of shell scripts.  Albeit, I did put in some logic to check for certain files in the mods directory to turn on/off some of them, as well, as exclude some packages and enable debugging... so ... follow along.

1. `/data/adb/modules/tdp-tweaks/tdp-debug`: This file will enable logging of all actions to the following location: `/data/adb/modules/tdp-tweaks/log.txt` If you have any issues with this module, I will be asking you for this log file...
    * Remove the file to turn this off
2. `/data/adb/modules/tdp-tweaks/tdp-excludes`: This file will be read line-by-line in order to exclude packages from the "disabler" scripts.  If you find some apps no longer work for you, you may want to add them in here to be skipped over...
    * This file is empty by default
3. `/data/adb/modules/tdp-tweaks/tdp-settings`: This file will enable some system settings tweaks.
    * This file is included by default
    * Remove this file to turn this off
4. `/data/adb/modules/tdp-tweaks/tdp-kernel`: This file will enable some kernel tweaks.
    * Remove this file to turn this off
5. `/data/adb/modules/tdp-tweaks/tdp-analytics`: This file will enable the analytics disabler.
    * Remove this file to turn this off
6. `/data/adb/modules/tdp-tweaks/tdp-diagnostics`: This file will enable the diagnostics disabler.
    * Remove this file to turn this off
7. `/data/adb/modules/tdp-tweaks/tdp-adservices`: This file will enable the ad services disabler.
    * Remove this file to turn this off
8. `/data/adb/modules/tdp-tweaks/tdp-tracking`: This file will enable the tracking disabler.
    * Remove this file to turn this off

## Requesting Support

First things first, I do this for myself and no-one else, and have simply decided to share it.  I don't owe you anything, so if you demand anything from me, you will either be ignored, or reported, or both.

Thus said, I cannot help without logs, so make sure that when you ask for help that you have turned on debugging for it (see above), you post the log.  At the very least I will need a Magisk log, which you can find in the management app.  Also helpful would be the log this module writes to (if you have enabled debugging)... it is located here: `/data/adb/modules/tdp-tweaks/log.txt`.  Also helpful would be a logcat, please google how to get this, as I will not hold anyones hand.

You can either file an issue in my repo, or reply to the thread on XDA.

## Bootlooping

This is actually pretty easy to recover from. If it happens to you, please follow these steps to recover... also note, this does not just go for my module, but any module that you may end up bootlooping with.

1. Hold your power button until you power off.
2. Once your device is off, press the power button and when the boot animation starts, press and hold your volume down, and keep holding it until it boots.
3. Once  you are in Safe Mode (you will know as your homescreen will show it), simply reboot your device.  Magisk detects safe mode and disables all modules.

Please note, and this is very important: **YMMV**

This process may be different for your device, but there is this great thing called the internet, and that can help you.  Here: https://www.google.com/search?q=how+do+I+boot+my+android+phone+into+safe+mode 

## Donations
Always welcomed, never required.

If you do decide to donate, please accept my thanks as I lift the beer(s) you bought to toast you :)

Donations can be processed here: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=QTT7BM7SQG46G
