#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(

    echo `date`;
    echo " --- Starting TDP Settings Tweaks ---"

    # boost battery
    echo " TDP Battery Booster ---"
    settings put global cached_apps_freezer enabled
    settings put global low_power_back_data_off
    settings put global restricted_device_performance 1,1

    # boost performance
    echo " TDP Performance Booster ---"
    settings put system min_refresh_rate 60.0
    settings put system previous_ram_expand_size 0
    settings put secure long_press_timeout 250
    settings put secure multi_press_timeout 250
    settings put global accessibility_reduce_transparency 1
    settings put global ram_expand_size 0

    # Display Tweaks
    echo " TDP Display Tweaks ---"
    settings put system accelerometer_rotation 0
    settings delete system auto_screen_on
    settings put system blue_light_filter 0
    settings put system blue_light_filter_adaptive_mode 0
    settings put system display_night_theme 1
    settings put system display_night_theme_wallpaper 0
    settings put system screen_mode_automatic_setting 0
    settings put system screen_off_pocket 0

    # tweak some feedback
    echo " TDP Feedback Tweaks Booster ---"
    settings put system camera_feedback_vibrate 0
    settings put system dialing_keypad_vibrate 0
    settings put system dtmf_tone 0
    settings put system haptic_feedback_enabled 0
    settings put system lockscreen_sounds_enabled 0
    settings put system navigation_gestures_vibrate 0
    settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY 0
    settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY 5
    settings put system SEM_VIBRATION_RING_INTENSITY 5
    settings put system sound_effects_enabled 0
    settings put system sync_vibration_with_notification 1
    settings put system sync_vibration_with_ringtone 1
    settings put system vibrate_when_ringing 1
    settings put system vibration_sound_enabled 0
    settings put system VIB_FEEDBACK_MAGNITUDE 0
    settings put system VIB_RECVCALL_MAGNITUDE 5
    settings put secure charging_sounds_enabled 0
    settings put secure charging_vibration_enabled 0
    settings put global dock_sounds_enabled 0
    settings put global emergency_tone 0
    settings put global power_sounds_enabled 0

    # tweak some gestures
    echo " TDP Gesture Tweaks ---"
    settings put system mcf_continuity 0
    settings put system master_motion 0
    settings put system motion_engine 0
    settings put system motion_pick_up 0
    settings put system air_motion_engine 0
    settings put system air_motion_wake_up 0
    settings put secure adaptive_sleep 0
    settings put secure aware_enabled 0
    settings put secure back_gesture_inset_scale_left 0.75
    settings put secure back_gesture_inset_scale_right 0.75
    settings put secure emergency_gesture_enabled 0
    settings put secure hush_gesture_used 0
    settings put secure silence_gesture 0
    settings put secure skip_gesture 0
    settings put secure volume_hush_gesture 0
    settings put global ambient_enabled 0
    settings put global ambient_tilt_to_wake 0
    settings put global ambient_touch_to_wake 0
    settings put global enable_back_animation 1

    # tweak a few google services
    echo " TDP Google Service Tweaks ---"
    settings put system direct_share 0
    settings put system gearhead:driving_mode_settings_enabled 0
    settings put secure smartspace 0
    settings put global google_core_control 0

    # tweak the lockscreen
    echo " TDP Lockscreen Tweaks ---"
    settings put system add_info_alarm 0
    settings put system add_info_today_schedule 0
    settings put system add_info_music_control 1
    settings put system facewidget_music_transparency 0
    settings delete system lockstar_enabled
    settings put system lock_editor_support_touch_hold 0
    settings put system lock_noticard_opacity 0
    settings put system screen_transition_effect 0
    settings put secure lock_screen_show_notifications 1
    settings put secure lock_screen_lock_after_timeout 0
    settings put secure lock_screen_owner_info_enabled 1

    # tweak our networking and telephony a bit
    echo " TDP Network & Telephony Tweaks ---"
    settings delete system block_unwanted_call
    settings put system call_answer_vib 1
    settings put system call_end_vib 1
    settings put system call_extra_volume 1
    settings put system call_noise_reduction 1
    settings put system call_popup 1
    settings put system display_caller_info_card 1
    settings delete system enable_call_protect_when_calling
    settings put system select_icon_1 4
    settings put system select_name_1 SWITCH
    settings put system wifi_call_enable1 0
    settings put system wifi_call_preferred1 0
    settings put secure data_preferred_mode_during_calling 1
    settings put global ble_scan_always_enabled 0
    settings put global data_roaming 0
    settings delete global default_restrict_background_data
    settings put global mobile_data_always_on 1
    settings put global mobile_signal_detector 0
    settings put global network_avoid_bad_wifi 0
    settings put global network_recommendations_enabled 0
    settings put global network_scoring_ui_enabled 0
    settings put global select_icon_1 4
    settings put global select_name_1 SWITCH
    settings put global sem_wifi_network_rating_scorer_enabled 0
    settings put global sem_wifi_switch_to_better_wifi_enabled 0
    settings put global sem_wifi_switch_to_better_wifi_supported 0
    settings put global swipe_to_call_message 0
    settings put global wifi_networks_available_notification_on 0
    settings put global wifi_scan_always_enabled 0

    # disable the screensaver
    echo " TDP Screensaver Tweaks ---"
    settings put secure screensaver_enabled 0
    settings put secure screensaver_activate_on_sleep 0
    settings put secure screensaver_activate_on_dock 0

    # tweak some system settings
    echo " TDP Settings Tweaks ---"
    settings put system access_control_enabled 0
    settings put system android.wallpaper.settings_systemui_transparency 0
    settings put system Flashlight_brightness_level 1001
    settings put system nearby_scanning_enabled 0
    settings put system people_stripe 0
    settings put system security_policy_update 1
    settings put system send_security_reports 0
    settings put secure backup_enabled 1
    settings put secure clipboard_show_access_notifications 1
    settings put secure notification_badging 0
    settings put secure notification_bubbles 0
    settings put secure show_notification_snooze 1
    settings put secure spell_checker_enabled 1
    settings put secure user_full_data_backup_aware 1
    settings put global assisted_gps_enabled 1
    settings put global bug_report 0
    settings put global master_sync_status 1
    settings put global retail_mode 0
    settings put global screen_call 0
    settings delete global send_action_app_error
    settings put global uwb_enabled 0
    settings put global wait_for_debugger 0
    settings delete system enable_mtp_settings

    # tweak security a tad
    echo " TDP Security Tweaks ---"
    settings put secure multi_control_connection_state 0
    settings delete secure wifi_adps_enable
    settings put secure tap_duration_threshold 0
    settings put secure touch_blocking_period 0

    # you don't need to autoconnect do you?
    echo " TDP Wifi Tweaks ---"
    settings put global auto_wifi 0

    # disable the global package verifier
    echo " TDP Package Verifier Tweaks ---"
    settings put global package_verifier_user_consent 0

    # tweak the location services a bit
    echo " TDP Location Tweaks ---"
    settings delete secure masterLocationPackagePrefixBlacklist
    settings delete secure masterLocationPackagePrefixWhitelist
    settings delete system location_ignore_settings_package_whitelist
    settings delete secure location_ignore_settings_package_whitelist
    settings delete global location_ignore_settings_package_whitelist

    # Set animation scales
    echo " TDP Animation Scale Tweaks ---"
    settings put global window_animation_scale 0.25
    settings put global transition_animation_scale 0.25
    settings put global animator_duration_scale 0.25

    # always doze
    echo " TDP Dozing Tweaks ---"
    settings put secure doze_always_on 0
    settings delete global device_idle_constants
    dumpsys deviceidle enable
    dumpsys deviceidle force-idle
    settings put global device_idle_constants inactive_to=300000,motion_inactive_to=120000,idle_after_inactive_to=300000,locating_to=10000,light_idle_to=300000,light_max_idle_to=600000,min_time_to_alarm=600000,idle_pending_factor=3.0,idle_factor=3.0
    device_config set_sync_disabled_for_tests persistent
    device_config put device_idle inactive_to 300000
    device_config put device_idle motion_inactive_to 120000
    device_config put device_idle idle_after_inactive_to 300000
    device_config put device_idle locating_to 10000
    device_config put device_idle light_idle_to 300000
    device_config put device_idle light_max_idle_to 600000
    device_config put device_idle min_time_to_alarm 600000
    device_config put device_idle idle_pending_factor 3.0
    device_config put device_idle idle_factor 3.0
    device_config set_sync_disabled_for_tests none

    # restrict abusive apps
    echo " TDP Restrict Abusive Apps ---"
    device_config put activity_manager bg_auto_restrict_abusive_apps 1
    device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled 1

    # disable GMS Intent Service, and then allow it to idle
    echo " TDP GMS Intent Tweaks ---"
    am force-stop com.google.android.gms
    dumpsys deviceidle whitelist -com.google.android.gms

    # disable well being background jobs
    echo " TDP Wellbeing Background Job Tweaks ---"
    cmd package disable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService
    cmd package disable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService

    # disable google system update service
    echo " TDP Google System Update Tweaks ---"
    cmd package enable com.google.android.gms/.update.SystemUpdateActivity
    cmd package enable com.google.android.gms/.update.SystemUpdateService
    cmd package enable com.google.android.gms/.update.SystemUpdateService$ActiveReceiver
    cmd package enable com.google.android.gms/.update.SystemUpdateService$Receiver
    cmd package enable com.google.android.gms/.update.SystemUpdateService$SecretCodeReceiver
    cmd package enable com.google.android.gsf/.update.SystemUpdateActivity
    cmd package enable com.google.android.gsf/.update.SystemUpdatePanoActivity
    cmd package enable com.google.android.gsf/.update.SystemUpdateService
    cmd package enable com.google.android.gsf/.update.SystemUpdateService$Receiver
    cmd package enable com.google.android.gsf/.update.SystemUpdateService$SecretCodeReceiver

    echo `date`;
    echo " --- Ending TDP Settings Tweaks ---"

) &
