#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    # Get a list of packages, uniquely sorted
    PACKAGES=$(cmd package list packages -f | sed -e 's/.*=//' | uniq | sort);

    # get a list of packages to exclude from this
    EXCLUDE=$(cat $MODDIR/tdp-exclude);

    echo `date`;
    echo " --- Starting TDP Diagnostics Disabler ---"

    # loop over all packages
    for pkg in $PACKAGES; 
    do

        # log it
        echo " Checking Package: $pkg"

        # see if the analytics services exist for the package
        exists=$(cmd package dump $pkg | grep -i 'diagno' | awk -F"cmp=" '{print $2}' | tail -n 1); 
        also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'diagno');

        # does the exclusion list exist?
        if [[ ! -z "$(cat ${EXCLUDE})" ]]; then 
        
            # is this packge in it?
            if [[ "${EXCLUDE[*]}" -eq *"$pkg"* ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # just continue
                continue 1

            fi;

        fi;

        # see if it exists
        if [[ ! -z "${exists// }" ]]; then

            # log it
            echo " Disabling: $exists"

            # it does, so disable it
            cmd package disable $exists

        fi;

        # now we need to split also_exists into multiple lines
        also_exists_here="${also_exists// /$'\n'}";

        # loop it
        for e in $also_exists_here;
        do
        
            # log it
            echo " Disabling: $e"

            # it does, so disable it
            cmd package disable $e

        done

    done 

    echo `date`;
    echo " --- Ending TDP Diagnostics Disabler ---"

    # make this script sleep for 4 hours
    sleep 4h

done
) & 
