#!/system/bin/sh

# setup logging
exec 3>&1 4>&2
trap 'exec 2>&4 1>&3' 0 1 2 3
exec 1>>$MODDIR/log.txt 2>&1

echo " --- Starting TDP Settings Tweaks ---" >&3

# boost battery
echo " TDP Battery Booster ---" >&3
settings put global cached_apps_freezer enabled >&3
settings put global low_power_back_data_off >&3
settings put global restricted_device_performance 1,1 >&3

# boost performance
echo " TDP Performance Booster ---" >&3
settings put system min_refresh_rate 60.0 >&3
settings put system previous_ram_expand_size 0 >&3
settings put secure long_press_timeout 250 >&3
settings put secure multi_press_timeout 250 >&3
settings put global accessibility_reduce_transparency 1 >&3
settings put global ram_expand_size 0 >&3

# Display Tweaks
echo " TDP Display Tweaks ---" >&3
settings put system accelerometer_rotation 0 >&3
settings delete system auto_screen_on >&3
settings put system blue_light_filter 0 >&3
settings put system blue_light_filter_adaptive_mode 0 >&3
settings put system display_night_theme 1 >&3
settings put system display_night_theme_wallpaper 0 >&3
settings put system screen_mode_automatic_setting 0 >&3
settings put system screen_off_pocket 0 >&3

# tweak some feedback
echo " TDP Feedback Tweaks Booster ---" >&3
settings put system camera_feedback_vibrate 0 >&3
settings put system dialing_keypad_vibrate 0 >&3
settings put system dtmf_tone 0 >&3
settings put system haptic_feedback_enabled 0 >&3
settings put system lockscreen_sounds_enabled 0 >&3
settings put system navigation_gestures_vibrate 0 >&3
settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY 0 >&3
settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY 5 >&3
settings put system SEM_VIBRATION_RING_INTENSITY 5 >&3
settings put system sound_effects_enabled 0 >&3
settings put system sync_vibration_with_notification 1 >&3
settings put system sync_vibration_with_ringtone 1 >&3
settings put system vibrate_when_ringing 1 >&3
settings put system vibration_sound_enabled 0 >&3
settings put system VIB_FEEDBACK_MAGNITUDE 0 >&3
settings put system VIB_RECVCALL_MAGNITUDE 5 >&3
settings put secure charging_sounds_enabled 0 >&3
settings put secure charging_vibration_enabled 0 >&3
settings put global dock_sounds_enabled 0 >&3
settings put global emergency_tone 0 >&3
settings put global power_sounds_enabled 0 >&3

# tweak some gestures
echo " TDP Gesture Tweaks ---" >&3
settings put system mcf_continuity 0 >&3
settings put system master_motion 0 >&3
settings put system motion_engine 0 >&3
settings put system motion_pick_up 0 >&3
settings put system air_motion_engine 0 >&3
settings put system air_motion_wake_up 0 >&3
settings put secure adaptive_sleep 0 >&3
settings put secure aware_enabled 0 >&3
settings put secure back_gesture_inset_scale_left 0.75 >&3
settings put secure back_gesture_inset_scale_right 0.75 >&3
settings put secure emergency_gesture_enabled 0 >&3
settings put secure hush_gesture_used 0 >&3
settings put secure silence_gesture 0 >&3
settings put secure skip_gesture 0 >&3
settings put secure volume_hush_gesture 0 >&3
settings put global ambient_enabled 0 >&3
settings put global ambient_tilt_to_wake 0 >&3
settings put global ambient_touch_to_wake 0 >&3
settings put global enable_back_animation 1 >&3

# tweak a few google services
echo " TDP Google Service Tweaks ---" >&3
settings put system direct_share 0 >&3
settings put system gearhead:driving_mode_settings_enabled 0 >&3
settings put secure smartspace 0 >&3
settings put global google_core_control 0 >&3

# tweak the lockscreen
echo " TDP Lockscreen Tweaks ---" >&3
settings put system add_info_alarm 0 >&3
settings put system add_info_today_schedule 0 >&3
settings put system add_info_music_control 1 >&3
settings put system facewidget_music_transparency 0 >&3
settings delete system lockstar_enabled >&3
settings put system lock_editor_support_touch_hold 0 >&3
settings put system lock_noticard_opacity 0 >&3
settings put system screen_transition_effect 0 >&3
settings put secure lock_screen_show_notifications 1 >&3
settings put secure lock_screen_lock_after_timeout 0 >&3
settings put secure lock_screen_owner_info_enabled 1 >&3

# tweak our networking and telephony a bit
echo " TDP Network & Telephony Tweaks ---" >&3
settings delete system block_unwanted_call >&3
settings put system call_answer_vib 1 >&3
settings put system call_end_vib 1 >&3
settings put system call_extra_volume 1 >&3
settings put system call_noise_reduction 1 >&3
settings put system call_popup 1 >&3
settings put system display_caller_info_card 1 >&3
settings delete system enable_call_protect_when_calling >&3
settings put system select_icon_1 4 >&3
settings put system select_name_1 SWITCH >&3
settings put system wifi_call_enable1 0 >&3
settings put system wifi_call_preferred1 0 >&3
settings put secure data_preferred_mode_during_calling 1 >&3
settings put global ble_scan_always_enabled 0 >&3
settings put global data_roaming 0 >&3
settings delete global default_restrict_background_data >&3
settings put global mobile_data_always_on 1 >&3
settings put global mobile_signal_detector 0 >&3
settings put global network_avoid_bad_wifi 0 >&3
settings put global network_recommendations_enabled 0 >&3
settings put global network_scoring_ui_enabled 0 >&3
settings put global select_icon_1 4 >&3
settings put global select_name_1 SWITCH >&3
settings put global sem_wifi_network_rating_scorer_enabled 0 >&3
settings put global sem_wifi_switch_to_better_wifi_enabled 0 >&3
settings put global sem_wifi_switch_to_better_wifi_supported 0 >&3
settings put global swipe_to_call_message 0 >&3
settings put global wifi_networks_available_notification_on 0 >&3
settings put global wifi_scan_always_enabled 0 >&3

# disable the screensaver
echo " TDP Screensaver Tweaks ---" >&3
settings put secure screensaver_enabled 0 >&3
settings put secure screensaver_activate_on_sleep 0 >&3
settings put secure screensaver_activate_on_dock 0 >&3

# tweak some system settings
echo " TDP Settings Tweaks ---" >&3
settings put system access_control_enabled 0 >&3
settings put system android.wallpaper.settings_systemui_transparency 0 >&3
settings put system Flashlight_brightness_level 1001 >&3
settings put system nearby_scanning_enabled 0 >&3
settings put system people_stripe 0 >&3
settings put system security_policy_update 1 >&3
settings put system send_security_reports 0 >&3
settings put secure backup_enabled 1 >&3
settings put secure clipboard_show_access_notifications 1 >&3
settings put secure notification_badging 0 >&3
settings put secure notification_bubbles 0 >&3
settings put secure show_notification_snooze 1 >&3
settings put secure spell_checker_enabled 1 >&3
settings put secure user_full_data_backup_aware 1 >&3
settings put global assisted_gps_enabled 1 >&3
settings put global bug_report 0 >&3
settings put global master_sync_status 1 >&3
settings put global retail_mode 0 >&3
settings put global screen_call 0 >&3
settings delete global send_action_app_error >&3
settings put global uwb_enabled 0 >&3
settings put global wait_for_debugger 0 >&3
settings delete system enable_mtp_settings >&3

# tweak security a tad
echo " TDP Security Tweaks ---" >&3
settings put secure multi_control_connection_state 0 >&3
settings delete secure wifi_adps_enable >&3
settings put secure tap_duration_threshold 0 >&3
settings put secure touch_blocking_period 0 >&3

# you don't need to autoconnect do you?
echo " TDP Wifi Tweaks ---" >&3
settings put global auto_wifi 0 >&3

# disable the global package verifier
echo " TDP Package Verifier Tweaks ---" >&3
settings put global package_verifier_user_consent 0 >&3

# tweak the location services a bit
echo " TDP Location Tweaks ---" >&3
settings delete secure masterLocationPackagePrefixBlacklist >&3
settings delete secure masterLocationPackagePrefixWhitelist >&3
settings delete system location_ignore_settings_package_whitelist >&3
settings delete secure location_ignore_settings_package_whitelist >&3
settings delete global location_ignore_settings_package_whitelist >&3

# Set animation scales
echo " TDP Animation Scale Tweaks ---" >&3
settings put global window_animation_scale 0.25 >&3
settings put global transition_animation_scale 0.25 >&3
settings put global animator_duration_scale 0.25 >&3

# always doze
echo " TDP Dozing Tweaks ---" >&3
settings put secure doze_always_on 0 >&3
settings delete global device_idle_constants >&3
dumpsys deviceidle enable >&3
dumpsys deviceidle force-idle >&3
settings put global device_idle_constants inactive_to=300000,motion_inactive_to=120000,idle_after_inactive_to=300000,locating_to=10000,light_idle_to=300000,light_max_idle_to=600000,min_time_to_alarm=600000,idle_pending_factor=3.0,idle_factor=3.0 >&3
device_config set_sync_disabled_for_tests persistent >&3
device_config put device_idle inactive_to 300000 >&3
device_config put device_idle motion_inactive_to 120000 >&3
device_config put device_idle idle_after_inactive_to 300000 >&3
device_config put device_idle locating_to 10000 >&3
device_config put device_idle light_idle_to 300000 >&3
device_config put device_idle light_max_idle_to 600000 >&3
device_config put device_idle min_time_to_alarm 600000 >&3
device_config put device_idle idle_pending_factor 3.0 >&3
device_config put device_idle idle_factor 3.0 >&3
device_config set_sync_disabled_for_tests none >&3

# restrict abusive apps
echo " TDP Restrict Abusive Apps ---" >&3
device_config put activity_manager bg_auto_restrict_abusive_apps 1 >&3
device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled 1 >&3

# disable GMS Intent Service, and then allow it to idle
echo " TDP GMS Intent Tweaks ---" >&3
am force-stop com.google.android.gms >&3
dumpsys deviceidle whitelist -com.google.android.gms >&3

# disable well being background jobs
echo " TDP Wellbeing Background Job Tweaks ---" >&3
cmd package disable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService >&3
cmd package disable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService >&3

# disable google system update service
echo " TDP Google System Update Tweaks ---" >&3
cmd package enable com.google.android.gms/.update.SystemUpdateActivity >&3
cmd package enable com.google.android.gms/.update.SystemUpdateService >&3
cmd package enable com.google.android.gms/.update.SystemUpdateService$ActiveReceiver >&3
cmd package enable com.google.android.gms/.update.SystemUpdateService$Receiver >&3
cmd package enable com.google.android.gms/.update.SystemUpdateService$SecretCodeReceiver >&3
cmd package enable com.google.android.gsf/.update.SystemUpdateActivity >&3
cmd package enable com.google.android.gsf/.update.SystemUpdatePanoActivity >&3
cmd package enable com.google.android.gsf/.update.SystemUpdateService >&3
cmd package enable com.google.android.gsf/.update.SystemUpdateService$Receiver >&3
cmd package enable com.google.android.gsf/.update.SystemUpdateService$SecretCodeReceiver >&3
