#!/system/bin/sh

# setup logging
exec 3>&1 4>&2
trap 'exec 2>&4 1>&3' 0 1 2 3
exec 1>>$MODDIR/log.txt 2>&1

# make this run in the background
(
while true
do

    # Get a list of packages, uniquely sorted
    PACKAGES=$(cmd package list packages -f | sed -e 's/.*=//' | uniq | sort);

    # get a list of packages to exclude from this
    EXCLUDE=$(cat /sdcard/Download/tdp-exclude);

    echo " --- Starting TDP Analytics Disabler ---" >&3

    # loop over all packages
    for pkg in $PACKAGES; 
    do 

        # see if the analytics services exist for the package
        exists=$(pm dump $pkg | grep -i 'analytics' | awk -F"cmp=" '{print $2}' | tail -n 1); 

        # check if included in the exclude list, if it is, skip
        if [[ ! -z "$(cat ${EXCLUDE})" ]] && [[ "${EXCLUDE[*]}" != *"$pkg"* ]]; then

            # see if it exists
            if [[ ! -z "${exists// }" ]]; then

                # log it
                echo " Disabling: $exists" >&3

                # it does, so disable it
                #cmd package disable $exists >&3

            fi;

        fi;

    done 

    echo " --- Ending TDP Analytics Disabler ---" >&3

    # make this script sleep for 4 hours
    sleep 4h

done
) & 
