#!/data/adb/magisk/busybox sh

# our module's directory
MODDIR=${0%/*}

# loop over the files in the backup dir
for i in $MODDIR/backup/*.bak; do

    # execute them
    source $i;

done

# get all our properties
PROPS=$(getprop | grep -e "persist.tdp" | sed -E "s/\[(.+)\]: (.*)/\1/g");
for p in $PROPS; do

    # set the true flag, this is done just in case we cannot remove the property
    setprop $p false

    # try to remove the property
    resetprop --delete $p

done;
