#!/data/adb/magisk/busybox sh

# our module's directory
MODDIR=${0%/*}

# our backup directory
BACKUPDIR=$MODDIR/backup

# hold the log files
THELOG=$MODDIR/log.txt
THEERRORLOG=$MODDIR/error.txt

# our excludes directory
EXCLUDESDIR=$MODDIR/excludes

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# clear the log files before anything else.  This happens every boot
> $THELOG;
> $THEERRORLOG;

(

    # Get a list of packages, uniquely sorted
    PACKAGES=$(pm list packages -f | sed -e 's/.*=//' | uniq | sort);

    # Get a list of user installed packages, uniquely sorted
    USER_PACKAGES=$(pm list packages -3 | sed 's/^package://' | uniq | sort);

    # export the moddir so we have access to it throughout
    export MODDIR;

    # export the backup directory so we have access to it throughout
    export BACKUPDIR;

    # export the excludes directory so we have access to it throughout
    export EXCLUDESDIR;

    # export the package list so it's available across everything
    export PACKAGES;

    # export the user packages for it's available across everything
    export USER_PACKAGES;

    # so we can use it elsewhere
    export BB;

    # log errors separate from the debugger
    exec 2> >(tee -a "$THEERRORLOG" >&2)

    # ------------------------------------------------------------------
    # - Build The Backup
    # ------------------------------------------------------------------
    if [[ ! -n $(getprop persist.tdp.backup_built) ]] || [[ $(getprop persist.tdp.backup_built) == false ]]; then

        # we haven't built it yet, do it now before anything else runs
        /data/adb/magisk/busybox sh $MODDIR/backup.sh;

        # now that it's done, set the property
        setprop persist.tdp.backup_built true;

        # Show a notification letting them know the backup has finished being built
        su -lp 2000 -c "cmd notification post -S bigtext -t 'Kevp75 TDP Tweaks' 'Tag' 'The backup script has finished building.  Feel free to enable the tweaks as you see fit. =)'";

    fi;

    # ------------------------------------------------------------------
    # - Start Debugging
    # ------------------------------------------------------------------

    # check if the debug file exists
    if [[ $(getprop persist.tdp.debugger) == true ]]; then

        # it does, so log everything in here
        exec > >(tee -a "$THELOG")

    fi;

    # ------------------------------------------------------------------
    # - End Debugging
    # ------------------------------------------------------------------

    # ------------------------------------------------------------------
    # - Start Tweaks
    # ------------------------------------------------------------------

    # if we're tweaking the kernel
    if [[ $(getprop persist.tdp.kernel) == true ]]; then

        # include our kernel tweaks
        source $MODDIR/includes/kernel.sh

    fi;

    # if we're tweaking the settings
    if [[ $(getprop persist.tdp.settings) == true ]]; then

        # include our settings tweaks
        source $MODDIR/includes/settings.sh

    fi;

    # if we're running the memory holder
    if [[ $(getprop persist.tdp.memory) == true ]]; then

        # include our memory holder
        source $MODDIR/includes/memory.sh

    fi;

    # if we're running the dozing holder
    if [[ $(getprop persist.tdp.dozing) == true ]]; then

        # include our dozing holder
        source $MODDIR/includes/dozing.sh

    fi;

    # if we're running the debugging holder
    if [[ $(getprop persist.tdp.debugging) == true ]]; then

        # include our debugging holder
        source $MODDIR/includes/debugging.sh

    fi;

    # if we're running the mount & IO tweaks
    if [[ $(getprop persist.tdp.io) == true ]]; then

        # include our debugging holder
        source $MODDIR/includes/mount.sh

    fi;

    # ------------------------------------------------------------------
    # - End Tweaks
    # ------------------------------------------------------------------

    # ------------------------------------------------------------------
    # - Start Blockers
    # ------------------------------------------------------------------

    # if we're disabling the analytics
    if [[ $(getprop persist.tdp.analytics) == true ]]; then

        # include our analytics disabler
        source $MODDIR/includes/analytics.sh

    fi;

    # if we're disabling the diagnostics
    if [[ $(getprop persist.tdp.diagnostics) == true ]]; then

        # include our diagnostics disabler
        source $MODDIR/includes/diagnostics.sh

    fi;

    # if we're disabling the adservices
    if [[ $(getprop persist.tdp.adservices) == true ]]; then

        # include our adservices disabler
        source $MODDIR/includes/adservices.sh

    fi;

    # if we're disabling the tracking
    if [[ $(getprop persist.tdp.tracking) == true ]]; then

        # include our tracking disabler
        source $MODDIR/includes/tracking.sh

    fi;

    # if we're running the sensor holder
    if [[ $(getprop persist.tdp.sensor) == true ]]; then

        # include our debugging holder
        source $MODDIR/includes/sensor.sh

    fi;

    # if we're running the wakelock blocker
    if [[ $(getprop persist.tdp.wakelock) == true ]]; then

        # include our debugging holder
        source $MODDIR/includes/wakelock.sh

    fi;

    # if we're running the run-in-background blocker
    if [[ $(getprop persist.tdp.runinbackground) == true ]]; then

        # include our debugging holder
        source $MODDIR/includes/runinbackground.sh

    fi;

    # ------------------------------------------------------------------
    # - End Blockers
    # ------------------------------------------------------------------

) &
