# TDP Tweaks by kevp75
## Details
* **Version:** 2.3.56
* **Platform API:** 32+
* **Android Version:** 12L+
* **Magisk Version:** 24.2+
* **Source Code:** https://gitlab.com/kp-development/android/tdp-tweaks.git 

This is a Magisk module that attempts to modify some settings and tweak some services for better device performance, better battery management, and better privacy.

It modifies some system settings, and then attempts to disable analytics services, ad services, diagnostic services, tracking services, wakelocks, and run-in-background packages.  Due to the nature of these services, some of them will run every 4 hours based on the time you last rebooted your device.

If you need help/support with this module, you will need to turn on debugging.  The module will pick this up and start logging on it's next run.  If you need the log right away, reboot your device after creating it.

**NOTE:**  I cannot be held responsible for bricks, world takeovers, or nuclear warfare.  As such, installing this mod is completely on you.  If you do not want this, do not flash it.

## Requirements
* **Platform API:** 32+
* **Android Version:** 12L+
* **Magisk Version:** 24.2+

## Install

1. Download the zip file, and open Magisk.
    * You can find it here: https://gitlab.com/kp-development/android/tdp-tweaks/-/releases/
2. Tap on Modules
3. Tap 'Install from storage' and browse to where you downloaded the zip file to.
4. Tap 'Ok'
5. Reboot
6. Sit back and enjoy your device

## How To Use

Open a shell... either use an app for it, or you can use `adb shell`.  Make sure you are root, and then type in `dp`

## Settings

There officially are no settings.  Either use a terminal based app or you can use `adb shell`.  Either way, you must be rooted.

However, there are some "extra" files in the module that will help you out... they are all located in the following folder: `/data/adb/modules/kevp75-tdp-tweaks/excludes`, and they contain some defaults

* adservices
    * add the package to exclude from the blocker on each line
* analytics
    * add the package to exclude from the blocker on each line
* diagnostics
    * add the package to exclude from the blocker on each line
* dozing
    * add the package with a `+` or `-` in front of it to add or remove from the forced dozer
        * `+` adds the package to the whitelist
        * `-` removes the package from the whitelist
* runinbackground
    * add the package to exclude from the blocker on each line
* sensor
    * add the package to exclude from the blocker on each line
* tracking
    * add the package to exclude from the blocker on each line
* wakelock
    * add the package to exclude from the blocker on each line

## Requesting Support

First things first, I do this for myself and no-one else, and have simply decided to share it.  I don't owe you anything, so if you demand anything from me, you will either be ignored, or reported, or both.

Thus said, I cannot help without logs, so make sure that when you ask for help that you have turned on debugging for it (see above), you post the log.  At the very least I will need a Magisk log, which you can find in the management app.  Also helpful would be the log this module writes to (if you have enabled debugging)... it is located here: `/data/adb/modules/kevp75-tdp-tweaks/log.txt` and here: `/data/adb/modules/kevp75-tdp-tweaks/error.txt`.  Also helpful would be a logcat, please google how to get this, as I will not hold anyones hand.

You can either file an issue in my repo, or reply to the thread on XDA.

## Bootlooping

This is actually pretty easy to recover from. If it happens to you, please follow these steps to recover... also note, this does not just go for my module, but any module that you may end up bootlooping with.

1. Hold your power button until you power off.
2. Once your device is off, press the power button and when the boot animation starts, press and hold your volume down, and keep holding it until it boots.
3. Once  you are in Safe Mode (you will know as your homescreen will show it), simply reboot your device.  Magisk detects safe mode and disables all modules.

Please note, and this is very important: **YMMV**

This process may be different for your device, but there is this great thing called the internet, and that can help you.  Here: https://www.google.com/search?q=how+do+I+boot+my+android+phone+into+safe+mode 

## Donations
Always welcomed, never required.

If you do decide to donate, please accept my thanks as I lift the beer(s) you bought to toast you :)

Donations can be processed here: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=QTT7BM7SQG46G

## Release Notes

### v. 2.3.56
* **Fix:** Disabling the tweaks
    * Now runs the backup generated to restore original settings
* **Fix:** Backup built check and flag
    * This fixes the duplication issue I found on my device after multiple reboots
* **Add:** Notification for backup building completion
* **Add:** Memory Tweaks based on the amount of RAM
* **Tweak:** Swappiness based on system RAM
* **Remove:** Build.Prop tweaks that were causing issues on some older devices
    * this may allow these tweaks to work on devices running Pie+ 
    * I do not have anything that runs anything lower than Snow Cone, so I cannot confirm this.

### v. 2.3.38
* **Rework:** Complete rewrite to allow for a control center for the different modules
    * See above
* **Add:** Wake Lock Blocker
* **Add:** Run In Background Blocker
* **Rework:** Backup system

### v. 1.9.22
* **Fix:** Sensor disabler

### v. 1.8.89
* **Update:** Commands to utilize the newest package manager
    * Changes requirement to at least API 32
* **Add:** Backup methodologies
    * Creates a new folder containing backups scripts to undo everything set
    * Backups scripts will be utilized with the uninstaller to undo everything done in these tweaks
* **Add:** Filesystem tweaks, see above to enable
* **Add:** Debugging disabler, see above for more information
* **Update:** Reworked how the Doze module works, to accomodate for the backup
* Some minor performance tweaks to the scripts
* **Add:** Busybox from Osmosis
    * Latest version in Magisk has a bug and is unusable
* **Add:** Add sensor disabler curtesy of: @primeprimes :)
    * See above to configure

### v. 1.6.12
* **Fix:** Memory module. Now properly holds packages in memory, also the package will be whitelisted from dozing
    * Ensures the package really does indeed get held in memory, since this is the case, it should also not doze
* **Remove:** Default packages from the memory module
* **Add:** Dozing module.
    * Removed from settings, and moved to it's own module
    * See notes about it above for how to configure it

### v. 1.5.87
* **Removed:** Some system settings deletions that were causing spam calls to come through after setting them to blocked
* **Add:** A couple performance build.prop tweaks
    * force opengl and VSYNC
* **Add:** A newer way to hold apps in memory
    * default holds 2 packages: com.android.systemui & com.android.launcher
    * see above to add more packages

### v. 1.4.04
* **Fix:** settings tweaks... now runs every 4 hours as well.
    * yes, some do reset to default states
* **Add:** added some networking and performance tweaks
* **Add:** added some build.prop tweaks thanks to @zaidannn7
* **Removed:** Defaults
    * from now on, you need to enable these yourself.  Read the above and you will figure out how to do it.

### v. 1.3.77
* **Remove:** gmsintent tweaks
    * causing too many issues with playstore updating and installing apps
    * disabled them by default last version
* **Remove:** googlesystem tweaks
    * causing too many issues with playstore updating and installing apps
    * disabled them by default last version
* **Remove:** haptic feadback disabler
* **Added:** App battery compiler
    * changes the apps profiles from speed
    * only runs once.  If you need to run it again, remove the `/data/add/modules/tdp-tweaks/.compilerran` file and reboot
    * this can cause some issues with some apps.  If you need to undo this, simply drop a new file in the module: `/data/add/modules/tdp-tweaks/tdp-undocompile` and reboot

### v. 1.3.01
* **Fix:** better search in the disablers for package exclusions
* **Improvement:** read `tdp-settings` for enabled settings sections
    * by default all sections are enabled. 
    * to disable: 
        * first backup `/data/adb/modules/tdp-tweaks/tdp-settings` 
        * remove the setting line(s) you want to disable
            * descriptions are above
        * save the file
        * reboot
* **Fix:** disable back animation
* **Fix:** move rest of wifi tweaks to the proper section
* **Remove:** Kernel tweaks for now.
    * I want to see if I can "detect" the current scheduler and tweak based on that

### v. 1.2.78
* Initial Release
