#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    echo `date`;
    echo " --- Starting TDP WakeLock Disabler ---"

    # loop over all packages
    for pkg in $PACKAGES; 
    do

        # log it
        echo " Checking Package: $pkg"

        # see if the analytics services exist for the package
        exists=$(cmd package dump $pkg | grep -i 'wake_l'); 
        also_exists=$(dumpsys package $pkg | grep -i 'wake_l');

        # does the exclusion list exist?
        if [[ -f "$EXCLUDESDIR/wakelock" ]]; then
        
            # is this packge in it?
            if [[ "$(grep -ic "$pkg" $EXCLUDESDIR/wakelock)" -ge 1 ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # just continue
                continue 1

            fi;

        fi;

        # see if it exists
        if [[ ! -z "$exists" ]] || [[ ! -z "$also_exists" ]]; then

            # log it
            echo " Disabling: $pkg"

            # it does, so disable it
            cmd appops set $pkg WAKE_LOCK ignore;

        fi;

    done 

    echo `date`;
    echo " --- Ending TDP Wake Lock Disabler ---"

    # make this script sleep for 4 hours
    sleep 8h

done
) & 
