#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # sync the filesystem
    sync

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Settings Tweaks ---"

    # boost battery
    if [[ $(getprop persist.tdp.tweak_battery) == true ]]; then

        echo " TDP Battery Booster ---"
        [ -n `settings get global cached_apps_freezer` ] && settings put global cached_apps_freezer enabled
        [ -n `settings get global low_power_back_data_off` ] && settings put global low_power_back_data_off enabled
        [ -n `settings get global restricted_device_performance` ] && settings put global restricted_device_performance 1,1
        [ -e /sys/module/battery_saver/parameters/enabled ] && echo Y > /sys/module/battery_saver/parameters/enabled
        [ -e /sys/module/workqueue/parameters/power_efficient ] && echo Y > /sys/module/workqueue/parameters/power_efficient
        [ -e /sys/devices/system/cpu/sched_mc_power_savings ] && echo 1 > /sys/devices/system/cpu/sched_mc_power_savings
        [ -e /sys/power/mem_sleep ] && echo deep > /sys/power/mem_sleep

    fi;

    # boost performance
    if [[ $(getprop persist.tdp.tweak_performance) == true ]]; then

        echo " TDP Performance Booster ---"
        [ -n `settings get global min_refresh_rate` ] && settings put system min_refresh_rate 60.0
        [ -n `settings get global previous_ram_expand_size` ] && settings put system previous_ram_expand_size 0
        [ -n `settings get global long_press_timeout` ] && settings put secure long_press_timeout 250
        [ -n `settings get global multi_press_timeout` ] && settings put secure multi_press_timeout 250
        [ -n `settings get global accessibility_reduce_transparency` ] && settings put global accessibility_reduce_transparency 1
        [ -n `settings get global ram_expand_size` ] && settings put global ram_expand_size 0

        # Lower Schedtune on background as it will consume quite a lot of power.
        [ -e /dev/stune/background/schedtune.boost ] && echo 2 > /dev/stune/background/schedtune.boost
        [ -e /dev/stune/background/schedtune.preferidle ] && echo 1 > /dev/stune/background/schedtune.preferidle

        # Slightly increase the number for Schedtune on Foreground appa to get a better experience.
        [ -e /dev/stune/foreground/schedtune.boost ] && echo 8 > /dev/stune/foreground/schedtune.boost
        [ -e /dev/stune/foreground/schedtune.preferidle ] && echo 0 > /dev/stune/foreground/schedtune.preferidle
        
        # Top-app is an app that is used frequently, so increasing the number will get more performance.
        [ -e /dev/stune/top-app/schedtune.boost ] && echo 25 > /dev/stune/top-app/schedtune.boost
        [ -e /dev/stune/top-app/schedtune.preferidle ] && echo 0 > /dev/stune/top-app/schedtune.preferidle


    fi;

    # Display Tweaks
    if [[ $(getprop persist.tdp.tweak_display) == true ]]; then

        echo " TDP Display Tweaks ---"
        [ -n `settings get system accelerometer_rotation` ] && settings put system accelerometer_rotation 0
        [ -n `settings get system auto_screen_on` ] && settings delete system auto_screen_on
        [ -n `settings get system blue_light_filter` ] && settings put system blue_light_filter 0
        [ -n `settings get system blue_light_filter_adaptive_mode` ] && settings put system blue_light_filter_adaptive_mode 0
        [ -n `settings get system display_night_theme` ] && settings put system display_night_theme 1
        [ -n `settings get system display_night_theme_wallpaper` ] && settings put system display_night_theme_wallpaper 0
        [ -n `settings get system screen_mode_automatic_setting` ] && settings put system screen_mode_automatic_setting 0
        [ -n `settings get system screen_off_pocket` ] && settings put system screen_off_pocket 0

    fi;

    # tweak some feedback
    if [[ $(getprop persist.tdp.tweak_feedback) == true ]]; then

        echo " TDP Feedback Tweaks Booster ---"
        [ -n `settings get system camera_feedback_vibrate` ] && settings put system camera_feedback_vibrate 0
        [ -n `settings get system dialing_keypad_vibrate` ] && settings put system dialing_keypad_vibrate 0
        [ -n `settings get system dtmf_tone` ] && settings put system dtmf_tone 0
        [ -n `settings get system lockscreen_sounds_enabled` ] && settings put system lockscreen_sounds_enabled 0
        [ -n `settings get system navigation_gestures_vibrate` ] && settings put system navigation_gestures_vibrate 0
        [ -n `settings get system SEM_VIBRATION_FORCE_TOUCH_INTENSITY` ] && settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY 0
        [ -n `settings get system SEM_VIBRATION_NOTIFICATION_INTENSITY` ] && settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY 5
        [ -n `settings get system SEM_VIBRATION_RING_INTENSITY` ] && settings put system SEM_VIBRATION_RING_INTENSITY 5
        [ -n `settings get system sound_effects_enabled` ] && settings put system sound_effects_enabled 0
        [ -n `settings get system sync_vibration_with_notification` ] && settings put system sync_vibration_with_notification 1
        [ -n `settings get system sync_vibration_with_ringtone` ] && settings put system sync_vibration_with_ringtone 1
        [ -n `settings get system vibrate_when_ringing` ] && settings put system vibrate_when_ringing 1
        [ -n `settings get system vibration_sound_enabled` ] && settings put system vibration_sound_enabled 0
        [ -n `settings get system VIB_FEEDBACK_MAGNITUDE` ] && settings put system VIB_FEEDBACK_MAGNITUDE 0
        [ -n `settings get system VIB_RECVCALL_MAGNITUDE` ] && settings put system VIB_RECVCALL_MAGNITUDE 5
        [ -n `settings get secure charging_sounds_enabled` ] && settings put secure charging_sounds_enabled 0
        [ -n `settings get secure charging_vibration_enabled` ] && settings put secure charging_vibration_enabled 0
        [ -n `settings get global dock_sounds_enabled` ] && settings put global dock_sounds_enabled 0
        [ -n `settings get global emergency_tone` ] && settings put global emergency_tone 0
        [ -n `settings get global power_sounds_enabled` ] && settings put global power_sounds_enabled 0

    fi;

    # tweak some gestures
    if [[ $(getprop persist.tdp.tweak_gesture) == true ]]; then

        echo " TDP Gesture Tweaks ---"
        [ -n `settings get system mcf_continuity` ] && settings put system mcf_continuity 0
        [ -n `settings get system master_motion` ] && settings put system master_motion 0
        [ -n `settings get system motion_engine` ] && settings put system motion_engine 0
        [ -n `settings get system motion_pick_up` ] && settings put system motion_pick_up 0
        [ -n `settings get system air_motion_engine` ] && settings put system air_motion_engine 0
        [ -n `settings get system air_motion_wake_up` ] && settings put system air_motion_wake_up 0
        [ -n `settings get secure adaptive_sleep` ] && settings put secure adaptive_sleep 0
        [ -n `settings get secure aware_enabled` ] && settings put secure aware_enabled 0
        [ -n `settings get secure back_gesture_inset_scale_left` ] && settings put secure back_gesture_inset_scale_left 0.75
        [ -n `settings get secure back_gesture_inset_scale_right` ] && settings put secure back_gesture_inset_scale_right 0.75
        [ -n `settings get secure emergency_gesture_enabled` ] && settings put secure emergency_gesture_enabled 0
        [ -n `settings get secure hush_gesture_used` ] && settings put secure hush_gesture_used 0
        [ -n `settings get secure silence_gesture` ] && settings put secure silence_gesture 0
        [ -n `settings get secure skip_gesture` ] && settings put secure skip_gesture 0
        [ -n `settings get secure volume_hush_gesture` ] && settings put secure volume_hush_gesture 0
        [ -n `settings get global ambient_enabled` ] && settings put global ambient_enabled 0
        [ -n `settings get global ambient_tilt_to_wake` ] && settings put global ambient_tilt_to_wake 0
        [ -n `settings get global ambient_touch_to_wake` ] && settings put global ambient_touch_to_wake 0
        [ -n `settings get global enable_back_animation` ] && settings put global enable_back_animation 0

    fi;

    # tweak a few google services
    if [[ $(getprop persist.tdp.tweak_gservice) == true ]]; then

        echo " TDP Google Service Tweaks ---"
        [ -n `settings get system direct_share` ] && settings put system direct_share 0
        [ -n `settings get system gearhead:driving_mode_settings_enabled` ] && settings put system gearhead:driving_mode_settings_enabled 0
        [ -n `settings get secure smartspace` ] && settings put secure smartspace 0
        [ -n `settings get global google_core_control` ] && settings put global google_core_control 0

    fi;

    # tweak the lockscreen
    if [[ $(getprop persist.tdp.tweak_lockscreen) == true ]]; then

        echo " TDP Lockscreen Tweaks ---"
        [ -n `settings get system add_info_alarm` ] && settings put system add_info_alarm 0
        [ -n `settings get system add_info_today_schedule` ] && settings put system add_info_today_schedule 0
        [ -n `settings get system add_info_music_control` ] && settings put system add_info_music_control 0
        [ -n `settings get system facewidget_music_transparency` ] && settings put system facewidget_music_transparency 0
        [ -n `settings get system lockstar_enabled` ] && settings delete system lockstar_enabled
        [ -n `settings get system lock_editor_support_touch_hold` ] && settings put system lock_editor_support_touch_hold 0
        [ -n `settings get system lock_noticard_opacity` ] && settings put system lock_noticard_opacity 0
        [ -n `settings get system screen_transition_effect` ] && settings put system screen_transition_effect 0
        [ -n `settings get secure lock_screen_show_notifications` ] && settings put secure lock_screen_show_notifications 0
        [ -n `settings get secure lock_screen_lock_after_timeout` ] && settings put secure lock_screen_lock_after_timeout 0
        [ -n `settings get secure lock_screen_owner_info_enabled` ] && settings put secure lock_screen_owner_info_enabled 0

    fi;

    # tweak our networking and telephony a bit
    if [[ $(getprop persist.tdp.tweak_telephony) == true ]]; then

        echo " TDP Telephony Tweaks ---"
        [ -n `settings get global ble_scan_always_enabled` ] && settings put global ble_scan_always_enabled 0
        [ -n `settings get global default_restrict_background_data` ] && settings delete global default_restrict_background_data
        [ -n `settings get global mobile_signal_detector` ] && settings put global mobile_signal_detector 0
        [ -n `settings get global network_recommendations_enabled` ] && settings put global network_recommendations_enabled 0
        [ -n `settings get global network_scoring_ui_enabled` ] && settings put global network_scoring_ui_enabled 0
        [ -n `settings get global swipe_to_call_message` ] && settings put global swipe_to_call_message 0

    fi;

    # disable the screensaver
    if [[ $(getprop persist.tdp.tweak_screensaver) == true ]]; then

        echo " TDP Screensaver Tweaks ---"
        [ -n `settings get secure screensaver_enabled` ] && settings put secure screensaver_enabled 0
        [ -n `settings get secure screensaver_activate_on_sleep` ] && settings put secure screensaver_activate_on_sleep 0
        [ -n `settings get secure screensaver_activate_on_dock` ] && settings put secure screensaver_activate_on_dock 0

    fi;

    # tweak some system settings
    if [[ $(getprop persist.tdp.tweak_settings) == true ]]; then

        echo " TDP Settings Tweaks ---"
        [ -n `settings get system access_control_enabled` ] && settings put system access_control_enabled 0
        [ -n `settings get system android.wallpaper.settings_systemui_transparency` ] && settings put system android.wallpaper.settings_systemui_transparency 0
        [ -n `settings get system Flashlight_brightness_level` ] && settings put system Flashlight_brightness_level 1001
        [ -n `settings get system nearby_scanning_enabled` ] && settings put system nearby_scanning_enabled 0
        [ -n `settings get system people_stripe` ] && settings put system people_stripe 0
        [ -n `settings get system security_policy_update` ] && settings put system security_policy_update 1
        [ -n `settings get system send_security_reports` ] && settings put system send_security_reports 0
        [ -n `settings get secure backup_enabled` ] && settings put secure backup_enabled 1
        [ -n `settings get secure clipboard_show_access_notifications` ] && settings put secure clipboard_show_access_notifications 1
        [ -n `settings get secure notification_badging` ] && settings put secure notification_badging 0
        [ -n `settings get secure notification_bubbles` ] && settings put secure notification_bubbles 0
        [ -n `settings get secure show_notification_snooze` ] && settings put secure show_notification_snooze 1
        [ -n `settings get secure spell_checker_enabled` ] && settings put secure spell_checker_enabled 1
        [ -n `settings get secure user_full_data_backup_aware` ] && settings put secure user_full_data_backup_aware 1
        [ -n `settings get global assisted_gps_enabled` ] && settings put global assisted_gps_enabled 1
        [ -n `settings get global bug_report` ] && settings put global bug_report 0
        [ -n `settings get global master_sync_status` ] && settings put global master_sync_status 1
        [ -n `settings get global retail_mode` ] && settings put global retail_mode 0
        [ -n `settings get global screen_call` ] && settings put global screen_call 0
        [ -n `settings get global send_action_app_error` ] && settings delete global send_action_app_error
        [ -n `settings get global uwb_enabled` ] && settings put global uwb_enabled 0
        [ -n `settings get global wait_for_debugger` ] && settings put global wait_for_debugger 0

    fi;

    # tweak security a tad
    if [[ $(getprop persist.tdp.tweak_security) == true ]]; then

        echo " TDP Security Tweaks ---"
        [ -n `settings get secure multi_control_connection_state` ] && echo settings put secure multi_control_connection_state 0
        [ -n `settings get secure wifi_adps_enable` ] && echo settings delete secure wifi_adps_enable
        [ -n `settings get secure tap_duration_threshold` ] && echo settings put secure tap_duration_threshold 0
        [ -n `settings get secure touch_blocking_period` ] && echo settings put secure touch_blocking_period 0

    fi;

    # you don't need to autoconnect do you?
    if [[ $(getprop persist.tdp.tweak_wifi) == true ]]; then

        echo " TDP Wifi Tweaks ---"
        [ -n `settings get global auto_wifi` ] && settings put global auto_wifi 0
        [ -n `settings get global sem_wifi_network_rating_scorer_enabled` ] && settings put global sem_wifi_network_rating_scorer_enabled 0
        [ -n `settings get global sem_wifi_switch_to_better_wifi_enabled` ] && settings put global sem_wifi_switch_to_better_wifi_enabled 0
        [ -n `settings get global sem_wifi_switch_to_better_wifi_supported` ] && settings put global sem_wifi_switch_to_better_wifi_supported 0
        [ -n `settings get global wifi_networks_available_notification_on` ] && settings put global wifi_networks_available_notification_on 0
        [ -n `settings get global wifi_scan_always_enabled` ] && settings put global wifi_scan_always_enabled 0

    fi;

    # disable the global package verifier
    if [[ $(getprop persist.tdp.tweak_pverifier) == true ]]; then

        echo " TDP Package Verifier Tweaks ---"
        [ -n `settings get global package_verifier_user_consent` ] && settings put global package_verifier_user_consent 0

    fi;

    # tweak the location services a bit
    if [[ $(getprop persist.tdp.tweak_location) == true ]]; then

        echo " TDP Location Tweaks ---"
        [ -n `settings get secure masterLocationPackagePrefixBlacklist` ] && settings delete secure masterLocationPackagePrefixBlacklist
        [ -n `settings get secure masterLocationPackagePrefixWhitelist` ] && settings delete secure masterLocationPackagePrefixWhitelist
        [ -n `settings get system location_ignore_settings_package_whitelist` ] && settings delete system location_ignore_settings_package_whitelist
        [ -n `settings get secure location_ignore_settings_package_whitelist` ] && settings delete secure location_ignore_settings_package_whitelist
        [ -n `settings get global location_ignore_settings_package_whitelist` ] && settings delete global location_ignore_settings_package_whitelist

    fi;

    # Set animation scales
    if [[ $(getprop persist.tdp.tweak_animation) == true ]]; then

# for some odd reason this doesn't stick in OOS, so, we're going to force it to stick
(
while true
do
        echo " TDP Animation Scale Tweaks ---"
        [ -n `settings get global window_animation_scale` ] && settings put global window_animation_scale 0.25
        [ -n `settings get global transition_animation_scale` ] && settings put global transition_animation_scale 0.25
        [ -n `settings get global animator_duration_scale` ] && settings put global animator_duration_scale 0.25

        # Change the value Schedtune.boost to get smoothness UI/UX and responsiveness touch
        [ -e /dev/stune/schedtune.boost ] && echo 7 > /dev/stune/schedtune.boost
        [ -e /dev/stune/schedtune.preferidle ] && echo 1 > /dev/stune/schedtune.preferidle

        # make it sleep for 1 hour
        sleep 1h

done
) & # make sure this is pushed to the background


    fi;

    # restrict abusive apps
    if [[ $(getprop persist.tdp.tweak_abusiveapps) == true ]]; then

        echo " TDP Restrict Abusive Apps ---"
        [ -n `device_config get activity_manager bg_auto_restrict_abusive_apps` ] && device_config put activity_manager bg_auto_restrict_abusive_apps 1
        [ -n `device_config get activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled` ] && device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled 1

    fi;

    # disable well being background jobs
    if [[ $(getprop persist.tdp.tweak_wellbeing) == true ]]; then

        # hold the name of the initial package
        WBPKG="com.google.android.apps.wellbeing"

        echo " TDP Wellbeing Background Job Tweaks ---"
        [ -f $(pm path $WBPKG | sed 's/package://') ] && pm disable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService
        [ -f $(pm path $WBPKG | sed 's/package://') ] && pm disable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService

    fi;

    # tweak the network, much thanks to @zaidannn7
    if [[ $(getprop persist.tdp.tweak_network) == true ]]; then

        echo " TDP Networking Tweaks ---"
        [ -e /proc/sys/net/core/wmem_max ] && echo 404480 > /proc/sys/net/core/wmem_max
        [ -e /proc/sys/net/core/rmem_max ] && echo 404480 > /proc/sys/net/core/rmem_max
        [ -e /proc/sys/net/core/rmem_default ] && echo 256960 > /proc/sys/net/core/rmem_default
        [ -e /proc/sys/net/core/wmem_default ] && echo 256960 > /proc/sys/net/core/wmem_default
        [ -e /proc/sys/net/ipv4/tcp_timestamps ] && echo 0 > /proc/sys/net/ipv4/tcp_timestamps
        [ -e /proc/sys/net/ipv4/tcp_tw_reuse ] && echo 1 > /proc/sys/net/ipv4/tcp_tw_reuse
        [ -e /proc/sys/net/ipv4/tcp_sack ] && echo 1 > /proc/sys/net/ipv4/tcp_sack
        [ -e /proc/sys/net/ipv4/tcp_tw_recycle ] && echo 1 > /proc/sys/net/ipv4/tcp_tw_recycle
        [ -e /proc/sys/net/ipv4/tcp_window_scaling ] && echo 1 > /proc/sys/net/ipv4/tcp_window_scaling
        [ -e /proc/sys/net/ipv4/tcp_keepalive_probes ] && echo 5 > /proc/sys/net/ipv4/tcp_keepalive_probes
        [ -e /proc/sys/net/ipv4/tcp_keepalive_intvl ] && echo 30 > /proc/sys/net/ipv4/tcp_keepalive_intvl
        [ -e /proc/sys/net/ipv4/tcp_fin_timeout ] && echo 30 > /proc/sys/net/ipv4/tcp_fin_timeout
        [ -e /proc/sys/net/ipv4/tcp_wmem ] && echo "262144 524288 8388608" > /proc/sys/net/ipv4/tcp_wmem
        [ -e /proc/sys/net/ipv4/tcp_mem ] && echo "262144 524288 8388608" > /proc/sys/net/ipv4/tcp_mem
        [ -e /proc/sys/net/ipv4/tcp_ecn ] && echo 1 > /proc/sys/net/ipv4/tcp_ecn
        [ -e /proc/sys/net/ipv4/tcp_fastopen ] && echo 3 > /proc/sys/net/ipv4/tcp_fastopen
        [ -e /proc/sys/net/ipv4/tcp_syncookies ] && echo 0 > /proc/sys/net/ipv4/tcp_syncookies

    fi;

    echo `date`;
    echo " --- Ending TDP Settings Tweaks ---"

    # make this script sleep for 8 hours
    sleep 12h

done
) &
