#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    echo `date`;
    echo " --- Starting TDP Sensor Blocker ---"

    # hold the packages
    THE_PKGS=$PACKAGES

    # loop over all user installed packages
    for pkg in $PACKAGES; 
    do

        # does the exclusion list exist?
        if [[ -f "$EXCLUDESDIR/sensor" ]]; then 
        
            # is this packge in it?
            if [[ "$(grep -ic "$pkg" $EXCLUDESDIR/sensor)" -ge 1 ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # remove the package from the package list
                THE_PKGS=$(echo $THE_PKGS | xargs | sed -e "s/$pkg//g")

            fi;

        fi;

    done

    # now create the comma-delimited list we need for this
    THE_PKGS=$(echo $THE_PKGS | xargs | sed -e 's/ /,/g')

    # disable the packages sensors
    [ -n `settings get system sensor_blocked_app` ] && settings put system sensor_blocked_app $THE_PKGS;

    echo `date`;
    echo " --- Ending TDP Sensor Blocker ---"

    # make this script sleep for 4 hours
    sleep 8h

done
) & 
