#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    echo `date`;
    echo " --- Starting TDP RIB Disabler ---"

    # loop over all packages
    for pkg in $PACKAGES; 
    do

        # log it
        echo " Checking Package: $pkg"

        # see if the analytics services exist for the package
        rib_exists=$(cmd package dump $pkg | grep -i 'run_in_'); 
        rib_also_exists=$(dumpsys package $pkg | grep -i 'run_in_');
        raib_exists=$(cmd package dump $pkg | grep -i 'run_any_in_'); 
        raib_also_exists=$(dumpsys package $pkg | grep -i 'run_any_in_');
        

        # does the exclusion list exist?
        if [[ -f "$EXCLUDESDIR/runinbackground" ]]; then
        
            # is this packge in it?
            if [[ "$(grep -ic "$pkg" $EXCLUDESDIR/runinbackground)" -ge 1 ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # just continue
                continue 1

            fi;

        fi;

        # see if it exists
        if [[ ! -z "$rib_exists" ]] || [[ ! -z "$rib_also_exists" ]]; then

            # log it
            echo " Disabling: $pkg"

            # it does, so disable it
            cmd appops set $pkg RUN_IN_BACKGROUND ignore;

        fi;

        # see if it exists
        if [[ ! -z "$raib_exists" ]] || [[ ! -z "$raib_also_exists" ]]; then

            # log it
            echo " Disabling: $pkg"

            # it does, so disable it
            cmd appops set $pkg RUN_ANY_IN_BACKGROUND ignore;

        fi;

    done 

    echo `date`;
    echo " --- Ending TDP RIB Disabler ---"

    # make this script sleep for 4 hours
    sleep 8h

done
) & 
