#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Mount & IO Tweaks ---"

    # fix up some mounts
	mount | grep ' ext4 .*rw' | awk '{print $3}' | xargs -n 1 mount -o remount,noatime,barrier=0,commit=60

	# trim them
	mount | grep ' ext4 .*rw' | awk '{print $3}' | xargs -n 1 fstrim -v

    # sync our filesystem
    sync

	# loop through some mounts and try to trim them
	for mnt in /data /system /cache /vendor /product /metadata /odm /system_ext; do

		# it it's one of these, the try to remount as RW
		if [ $mnt = "/system_ext" ] || [ $mnt = "/system" ] || [ $mnt = "/product" ] || [ $mnt = "/vendor" ] || [ $mnt = "/odm" ]; then

			# try to remount
			mount -o rw,remount $mnt;

		fi;

		# try to trim it.s
		fstrim -v $mnt;

		# it it's one of these, the try to remount as RO
		if [ $mnt = "/system_ext" ] || [ $mnt = "/system" ] || [ $mnt = "/product" ] || [ $mnt = "/vendor" ] || [ $mnt = "/odm" ]; then

			# try to remount
			mount -o ro,remount $mnt;

		fi;

	done; 

    echo " TDP Filesystem Tweaks ---"

    # tweak the queues for each attached block device
    for queue in /sys/block/*/queue; do
        [ -e $queue/iostats ] && echo 0 > $queue/iostats
        [ -e $queue/read_ahead_kb ] && echo 128 > $queue/read_ahead_kb
        [ -e $queue/nr_requests ] && echo 64 > $queue/nr_requests
    done

    # turn off notifications and i/o stats
    [ -e /proc/sys/fs/dir-notify-enable ] && echo 0 > /proc/sys/fs/dir-notify-enable
    [ -e /proc/sys/fs/by-name/userdata/iostat_enable ] && echo 0 > /proc/sys/fs/by-name/userdata/iostat_enable
    [ -e /sys/module/fuse/parameters/max_user_bgreq ] && echo 1022 > /sys/module/fuse/parameters/max_user_bgreq
    [ -e /sys/module/fuse/parameters/max_user_congthresh ] && echo 1022 > /sys/module/fuse/parameters/max_user_congthresh

    echo `date`;
    echo " --- Ending TDP Mount & IO Tweaks ---"

    # make this script sleep for 4 hours
    sleep 24h

done
) &
