#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Memory Tweaks ---"

    # Gather up some info
    MEM=$(grep MemTotal /proc/meminfo | sed -E "s/^MemTotal:(.+) kB/\1/g" | sed 's/^[ \t]*//');
    BYTES=`expr $MEM \* 1024`
    FREE5=$(awk -vn=$MEM 'BEGIN{print(n*0.05)}')
    MCSIZE=`expr $BYTES \/ 64`
    PBYTES=`expr $BYTES \/ 128`

    # tweak the way the kernel utilizes virtual memory
    [ -e /sys/kernel/mm/swap/vma_ra_enabled ] && echo true > /sys/kernel/mm/swap/vma_ra_enabled
    [ -e /proc/sys/vm/compact_unevictable_allowed ] && echo 0 /proc/sys/vm/compact_unevictable_allowed
    [ -e /proc/sys/vm/extfrag_threshold ] && echo 750 /proc/sys/vm/extfrag_threshold
    [ -e /proc/sys/vm/stat_interval ] && echo 10 > /proc/sys/vm/stat_interval
    [ -e /proc/sys/vm/page-cluster ] && echo 0 > /proc/sys/vm/page-cluster
    [ -e /proc/sys/vm/panic_on_oom ] && echo 0 > /proc/sys/vm/panic_on_oom
    # turn on trasparent huge page VM
    [ -e /sys/kernel/mm/transparent_hugepage/enabled ] && echo always > cat /sys/kernel/mm/transparent_hugepage/enabled
    [ -e /sys/kernel/mm/transparent_hugepage/defrag ] && echo defer > /sys/kernel/mm/transparent_hugepage/defrag
    [ -e /sys/kernel/mm/transparent_hugepage/khugepaged/max_ptes_swap ] && echo 8 > /sys/kernel/mm/transparent_hugepage/khugepaged/max_ptes_swap
    # turn off the zram swap.. we don't need it
    [ -n `settings get global zram_enabled` ] && settings put global zram_enabled 0

    # tweak some block memory usages
    [ -e /sys/block/sda/queue/read_ahead_kb ] && echo 256 > /sys/block/sda/queue/read_ahead_kb
    [ -e /sys/block/sde/queue/read_ahead_kb ] && echo 256 > /sys/block/sde/queue/read_ahead_kb
    [ -e /sys/block/sda/queue/nr_requests ] && echo 128 > /sys/block/sda/queue/nr_requests
    [ -e /sys/block/sde/queue/nr_requests ] && echo 128 > /sys/block/sde/queue/nr_requests
    [ -e /sys/block/sda/queue/rq_affinity ] && echo 2 > /sys/block/sda/queue/rq_affinity
    [ -e /sys/block/sde/queue/rq_affinity ] && echo 2 > /sys/block/sde/queue/rq_affinity
    [ -e /proc/sys/vm/overcommit_memory ] && echo 0 > /proc/sys/vm/overcommit_memory

    # cache tweaks                                                
    [ -e /sys/module/dm_bufio/parameters/max_cache_size_bytes ] && echo $MCSIZE > /sys/module/dm_bufio/parameters/max_cache_size_bytes
    [ -e /sys/module/dm_bufio/parameters/peak_allocated_bytes ] && echo $PBYTES > /sys/module/dm_bufio/parameters/peak_allocated_bytes

    # ram caching tweaks
    [ -e /proc/sys/vm/vfs_cache_pressure ] && echo 70 > /proc/sys/vm/vfs_cache_pressure
	[ -e /proc/sys/vm/watermark_scale_factor ] && echo 30 > /proc/sys/vm/watermark_scale_factor
	[ -e /proc/sys/vm/compaction_proactiveness ] && echo 0 > /proc/sys/vm/compaction_proactiveness
    [ -e /proc/sys/vm/min_free_kbytes ] && echo $FREE5 > /proc/sys/vm/min_free_kbytes

    # if our total memory is greater than or equal to 12G
    if [[ 12884901888 -ge $BYTES ]]; then

        # we can tone down the swappiness consiuderably
        [ -e /proc/sys/vm/swappiness ] && echo 30 > /proc/sys/vm/swappiness

    # if our total memory is greater than 8G
    elif [[ 8589934592 -lt $BYTES ]]; then

        # we can tone down the swappiness
        [ -e /proc/sys/vm/swappiness ] && echo 60 > /proc/sys/vm/swappiness

    # if our total memory is less than or equal to 8G
    elif [[ 8589934592 -le $BYTES ]]; then

        # we can swap a tad more agressively, so set it to 100
        [ -e /proc/sys/vm/swappiness ] && echo 100 > /proc/sys/vm/swappiness

    # if our total memory is less than or equal to 4G
    elif [[ 4294967296 -le $BYTES ]]; then

        # we can swap a more agressively, so set it to 120
        [ -e /proc/sys/vm/swappiness ] && echo 120 > /proc/sys/vm/swappiness    

    fi;
	

    # let's clean up a little ;)
    sync && echo 3 > /proc/sys/vm/drop_caches

    echo `date`;
    echo " --- Ending TDP Memory Tweaks ---"

    # make this script sleep for 12 hours
    sleep 12h

done
) &
