#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    echo `date`;
    echo " --- Starting TDP Debugging Disabler ---"

    # Loop over known debugging services
    for i in 'logcat' 'logcatd' 'logd' 'tcpdump' 'cnss_diag' 'statsd' 'traced' 'idd-logreader' 'idd-logreadermain' 'stats' 'dumpstate' 'aplogd'; do

        # kill them... now!
        killall -9 $i;

    done;

    # Kernel Debugging (thx to KTSR)
    for i in 'debug_mask' 'log_level*' 'debug_level*' '*debug_mode' 'edac_mc_log*' 'enable_event_log' '*log_level*' '*log_ue*' '*log_ce*' 'log_ecn_error' 'snapshot_crashdumper' 'seclog*' 'compat-log' '*log_enabled' 'tracing_on' 'mballoc_debug'; do
        for o in $(find /sys/ -type f -name "$i"); do

            # turn it off!    
            echo 0 > $o
        
        done
    done

    # Printk (thx to KNTD-reborn)
    [ -e /proc/sys/kernel/printk ] && echo '0 0 0 0' > /proc/sys/kernel/printk
    [ -e /sys/module/printk/parameters/cpu ] && echo 0 > /sys/module/printk/parameters/cpu
    [ -e /sys/module/printk/parameters/console_suspend ] && echo 1 > /sys/module/printk/parameters/console_suspend
    [ -e /sys/kernel/printk_mode/printk_mode ] && echo 0 > /sys/kernel/printk_mode/printk_mode
    [ -e /sys/module/printk/parameters/ignore_loglevel ] && echo 1 > /sys/module/printk/parameters/ignore_loglevel
    [ -e /sys/module/printk/parameters/pid ] && echo 0 > /sys/module/printk/parameters/pid
    [ -e /sys/module/printk/parameters/time ] && echo 0 > /sys/module/printk/parameters/time
    [ -e /sys/module/printk/parameters/printk_ratelimit ] && echo 0 > /sys/module/printk/parameters/printk_ratelimit
    [ -e /proc/sys/kernel/printk_devkmsg ] && echo off > /proc/sys/kernel/printk_devkmsg
    [ -n `settings get global activity_starts_logging_enabled` ] && settings put global activity_starts_logging_enabled 0

    # turn off panic's
	sysctl -w vm.panic_on_oom=0
	sysctl -w kernel.panic_on_oops=0
	sysctl -w kernel.panic=0

    echo `date`;
    echo " --- Ending TDP Debugging Disabler ---"

    # make this script sleep for 4 hours
    sleep 12h

done
) & 
