#!/data/adb/magisk/busybox sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do


    echo `date`;
    echo " --- Starting TDP Ad Services Disabler ---"

    # loop over all packages
    for pkg in $PACKAGES; 
    do

        # log it
        echo " Checking Package: $pkg"

        # see if the analytics services exist for the package
        exists=$(cmd package dump $pkg | grep -i 'adserv' | awk -F"cmp=" '{print $2}' | tail -n 1); 
        also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'adserv');

        # does the exclusion list exist?
        if [[ -f "$EXCLUDESDIR/adservices" ]]; then
        
            # is this packge in it?
            if [[ $(grep -ic "$pkg" $EXCLUDESDIR/adservices) -ge 1 ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # just continue
                continue 1

            fi;

        fi;

        # see if it exists
        if [[ ! -z "${exists// }" ]]; then

            # log it
            echo " Disabling: $exists"

            # it does, so disable it
            pm disable $exists

        fi;

        # now we need to split also_exists into multiple lines
        also_exists_here="${also_exists// /$'\n'}";

        # loop it
        for e in $also_exists_here;
        do
        
            # log it
            echo " Disabling: $e"

            # it does, so disable it
            pm disable $e

        done

    done 

    echo `date`;
    echo " --- Ending TDP Ad Services Disabler ---"

    # make this script sleep for 4 hours
    sleep 8h

done
) & 
