#!/system/bin/sh

# Android 12.1 or newer
if [[ "$(getprop ro.build.version.sdk)" -lt 31 ]]; then
    ui_print ""
    ui_print "This cannot be used on anything older than Android 12L."
    ui_print ""

fi

ui_print "---------------------------------------------"
ui_print " Setting some permissions"
mkdir -p "$MODPATH/backup"

set_perm  $MODPATH/service.sh 0 0 0755
set_perm  $MODPATH/backup.sh 0 0 0755
set_perm  $MODPATH/post-fs-data.sh 0 0 0755
set_perm  $MODPATH/uninstall.sh 0 0 0755
set_perm  $MODPATH/system/bin/logd 0 0 0755
set_perm  $MODPATH/system/bin/dp 0 0 0755
set_perm_recursive $MODPATH/backup 0 0 0755
set_perm_recursive $MODPATH/includes 0 0 0755
chcon u:r:magisk:s0 $MODPATH/service.sh
chcon u:r:magisk:s0 $MODPATH/backup.sh
chcon u:r:magisk:s0 $MODPATH/post-fs-data.sh
chcon u:r:magisk:s0 $MODPATH/uninstall.sh
chcon u:r:magisk:s0 $MODPATH/system/bin/dp

ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
ui_print " IMPORTANT!"
ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
ui_print " After you reboot, do not run 'dp'"
ui_print " until you get the notification that the"
ui_print " backups are done being built."
ui_print ""
ui_print " This is going to take some time"
ui_print " Have Patience, it will finish... eventually"
ui_print ""
ui_print " It is necessary in order to build the "
ui_print " backup scripts, per your device's"
ui_print " original settings and configuration."
ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
ui_print " YOU HAVE BEEN WARNED!"
ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
sleep 5

ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
ui_print " All Set!"
ui_print " You Can Reboot Now"
ui_print "---------------------------------------------"
ui_print "---------------------------------------------"
