#!/data/adb/magisk/busybox sh

# our module's directory
MODDIR=${0%/*}

# our backup directory
BACKUPDIR=$MODDIR/backup

# our excludes directory
EXCLUDESDIR=$MODDIR/excludes

# Get a list of packages, uniquely sorted
PACKAGES=$(pm list packages -f | sed -e 's/.*=//' | uniq | sort);

# see if the backup files already exist, if they do remove them
idx=1;
for i in $BACKUPDIR/*.bak; do
    # just increment
    idx+=1;
done
if [ $idx == 13 ]; then
    # remove them all
    rm -f $BACKUPDIR/*
fi;

# ------------------------------------------------------------------
# - Ad Services
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/adservices.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the analytics services exist for the package
    exists=$(cmd package dump $pkg | grep -i 'adserv' | awk -F"cmp=" '{print $2}' | tail -n 1); 
    also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'adserv');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/adservices" ]]; then
    
        # is this packge in it?
        if [[ $(grep -ic "$pkg" $EXCLUDESDIR/adservices) -ge 1 ]]; then
            continue 1
        fi;

    fi;

    # see if it exists
    if [[ ! -z "${exists// }" ]]; then

        # write the enable command to our backup file
        echo "pm enable $exists;" >> $BACKUP

    fi;

    # now we need to split also_exists into multiple lines
    also_exists_here="${also_exists// /$'\n'}";

    # loop it
    for e in $also_exists_here;
    do
    
        echo "pm enable $e;" >> $BACKUP

    done

done;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Analytics
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/analytics.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the analytics services exist for the package
    exists=$(cmd package dump $pkg | grep -i 'analyt' | awk -F"cmp=" '{print $2}' | tail -n 1); 
    also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'analyt');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/analytics" ]]; then
    
        # is this packge in it?
        if [[ $(grep -ic "$pkg" $EXCLUDESDIR/analytics) -ge 1 ]]; then
            continue 1
        fi;

    fi;

    # see if it exists
    if [[ ! -z "${exists// }" ]]; then

        # write the enable command to our backup file
        echo "pm enable $exists;" >> $BACKUP

    fi;

    # now we need to split also_exists into multiple lines
    also_exists_here="${also_exists// /$'\n'}";

    # loop it
    for e in $also_exists_here;
    do
    
        echo "pm enable $e;" >> $BACKUP

    done

done;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Debugging
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/debugging.bak
touch $BACKUP;

# write out backup
for i in 'debug_mask' 'log_level*' 'debug_level*' '*debug_mode' 'edac_mc_log*' 'enable_event_log' '*log_level*' '*log_ue*' '*log_ce*' 'log_ecn_error' 'snapshot_crashdumper' 'seclog*' 'compat-log' '*log_enabled' 'tracing_on' 'mballoc_debug'; do
    for o in $(find /sys/ -type f -name "$i"); do

        # turn it off!    
        echo "echo `cat $o` > $o" >> $BACKUP
    
    done
done
[ -e /proc/sys/kernel/printk ] && echo "echo '`cat /proc/sys/kernel/printk`' > /proc/sys/kernel/printk" >> $BACKUP;
[ -e /sys/module/printk/parameters/cpu ] && echo "echo `cat /sys/module/printk/parameters/cpu` > /sys/module/printk/parameters/cpu" >> $BACKUP;
[ -e /sys/module/printk/parameters/console_suspend ] && echo "echo `cat /sys/module/printk/parameters/console_suspend` > /sys/module/printk/parameters/console_suspend" >> $BACKUP;
[ -e /sys/kernel/printk_mode/printk_mode ] && echo "echo `cat /sys/kernel/printk_mode/printk_mode` > /sys/kernel/printk_mode/printk_mode" >> $BACKUP;
[ -e /sys/module/printk/parameters/ignore_loglevel ] && echo "echo `cat /sys/module/printk/parameters/ignore_loglevel` > /sys/module/printk/parameters/ignore_loglevel" >> $BACKUP;
[ -e /sys/module/printk/parameters/pid ] && echo "echo `cat /sys/module/printk/parameters/pid` > /sys/module/printk/parameters/pid" >> $BACKUP;
[ -e /sys/module/printk/parameters/time ] && echo "echo `cat /sys/module/printk/parameters/time` > /sys/module/printk/parameters/time" >> $BACKUP;
[ -e /sys/module/printk/parameters/printk_ratelimit ] && echo "echo `cat /sys/module/printk/parameters/printk_ratelimit` > /sys/module/printk/parameters/printk_ratelimit" >> $BACKUP;
[ -e /proc/sys/kernel/printk_devkmsg ] && echo "echo `cat /proc/sys/kernel/printk_devkmsg` > /proc/sys/kernel/printk_devkmsg" >> $BACKUP;
[ -n `settings get global activity_starts_logging_enabled` ] && echo "settings put global activity_starts_logging_enabled `settings get global activity_starts_logging_enabled`" >> $BACKUP;
echo "sysctl -w vm.panic_on_oom=1" >> $BACKUP;
echo "sysctl -w kernel.panic_on_oops=1" >> $BACKUP;
echo "sysctl -w kernel.panic=1" >> $BACKUP;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Diagnostics
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/diagnostics.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the diagnostics services exist for the package
    exists=$(cmd package dump $pkg | grep -i 'diagno' | awk -F"cmp=" '{print $2}' | tail -n 1); 
    also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'diagno');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/diagnostics" ]]; then
    
        # is this packge in it?
        if [[ $(grep -ic "$pkg" $EXCLUDESDIR/diagnostics) -ge 1 ]]; then
            continue 1
        fi;

    fi;

    # see if it exists
    if [[ ! -z "${exists// }" ]]; then

        # write the enable command to our backup file
        echo "pm enable $exists;" >> $BACKUP

    fi;

    # now we need to split also_exists into multiple lines
    also_exists_here="${also_exists// /$'\n'}";

    # loop it
    for e in $also_exists_here;
    do
    
        echo "pm enable $e;" >> $BACKUP

    done

done;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Dozing
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/dozing.bak
touch $BACKUP;

# hold the configured package string
HELDPKGS=$(cat $EXCLUDESDIR/dozing | xargs | sed -e 's/ /,/g')

# loop over the configured packages
for pkg in $(echo $HELDPKGS | sed "s/,/ /g"); 
do

    # hold the actual package
    the_pkg=$(echo $pkg | sed "s/+//g");
    the_pkg=$(echo $the_pkg | sed "s/-//g");

    # if the app is whitelisted
    if [[ "$pkg" == *"+"* ]]; then 

        # echo out the reverse to the backup
        echo "am set-inactive $the_pkg true" >> $BACKUP;
        echo "dumpsys deviceidle whitelist -$the_pkg" >> $BACKUP;

    fi;

    # if the app is blacklisted
    if [[ "$pkg" == *"-"* ]]; then 

        # echo out the reverse to the backup
        echo "am set-inactive $the_pkg false" >> $BACKUP;
        echo "dumpsys deviceidle whitelist +$the_pkg" >> $BACKUP;

    fi;

done;

# write it out
[ -n `settings get global device_idle_constants` ] && echo "settings put global device_idle_constants `settings get global device_idle_constants`" >> $BACKUP;
echo "device_config set_sync_disabled_for_tests none" >> $BACKUP;

# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Kernel
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/kernel.bak
touch $BACKUP;

# we need to get all these settings and echo them out to our backup
[ -e /sys/kernel/mm/lru_gen/enabled ] && echo "echo `cat /sys/kernel/mm/lru_gen/enabled` > /sys/kernel/mm/lru_gen/enabled" >> $BACKUP;
[ -e /sys/kernel/mm/lru_gen/min_ttl_ms ] && echo "echo `cat /sys/kernel/mm/lru_gen/min_ttl_ms` > /sys/kernel/mm/lru_gen/min_ttl_ms" >> $BACKUP;
[ -e /proc/sys/kernel/sched_migration_cost_ns ] && echo "echo '`cat /proc/sys/kernel/sched_migration_cost_ns`' > /proc/sys/kernel/sched_migration_cost_ns" >> $BACKUP;
[ -e /proc/sys/kernel/sched_child_runs_first ] && echo "echo '`cat /proc/sys/kernel/sched_child_runs_first`' > /proc/sys/kernel/sched_child_runs_first" >> $BACKUP;
[ -e /proc/sys/kernel/sched_autogroup_enabled ] && echo "echo '`cat /proc/sys/kernel/sched_autogroup_enabled`' > /proc/sys/kernel/sched_autogroup_enabled" >> $BACKUP;
[ -e /proc/sys/kernel/sched_tunable_scaling ] && echo "echo '`cat /proc/sys/kernel/sched_tunable_scaling`' > /proc/sys/kernel/sched_tunable_scaling" >> $BACKUP;
[ -e /proc/sys/kernel/hung_task_timeout_secs ] && echo "echo '`cat /proc/sys/kernel/hung_task_timeout_secs`' > /proc/sys/kernel/hung_task_timeout_secs" >> $BACKUP;
[ -e /proc/sys/kernel/perf_cpu_time_max_percent ] && echo "echo '`cat /proc/sys/kernel/perf_cpu_time_max_percent`' > /proc/sys/kernel/perf_cpu_time_max_percent" >> $BACKUP;
[ -e /proc/sys/kernel/timer_migration ] && echo "echo '`cat /proc/sys/kernel/timer_migration`' > /proc/sys/kernel/timer_migration" >> $BACKUP;
[ -e /proc/sys/kernel/sched_schedstats ] && echo "echo `cat /proc/sys/kernel/sched_schedstats` > /proc/sys/kernel/sched_schedstats" >> $BACKUP;
[ -e /proc/sys/kernel/sched_latency_ns ] && echo "echo `cat /proc/sys/kernel/sched_latency_ns` > /proc/sys/kernel/sched_latency_ns" >> $BACKUP;
[ -e /proc/sys/kernel/sched_nr_migrate ] && echo "echo `cat /proc/sys/kernel/sched_nr_migrate` > /proc/sys/kernel/sched_nr_migrate" >> $BACKUP;

# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Memory
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/memory.bak
touch $BACKUP;

# write the original values
[ -e /sys/kernel/mm/swap/vma_ra_enabled ] && echo "echo `cat /sys/kernel/mm/swap/vma_ra_enabled` > /sys/kernel/mm/swap/vma_ra_enabled" >> $BACKUP;
[ -e /proc/sys/vm/page-cluster ] && echo "echo `cat /proc/sys/vm/page-cluster` > /proc/sys/vm/page-cluster" >> $BACKUP;
[ -e /proc/sys/vm/compact_unevictable_allowed ] && echo "echo `cat /proc/sys/vm/compact_unevictable_allowed` > /proc/sys/vm/compact_unevictable_allowed" >> $BACKUP;
[ -e /proc/sys/vm/extfrag_threshold ] && echo "echo `cat /proc/sys/vm/extfrag_threshold` > /proc/sys/vm/extfrag_threshold" >> $BACKUP;
[ -e /sys/block/sda/queue/read_ahead_kb ] && echo "echo `cat /sys/block/sda/queue/read_ahead_kb` > /sys/block/sda/queue/read_ahead_kb" >> $BACKUP;
[ -e /sys/block/sde/queue/read_ahead_kb ] && echo "echo `cat /sys/block/sde/queue/read_ahead_kb` > /sys/block/sde/queue/read_ahead_kb" >> $BACKUP;
[ -e /sys/block/sda/queue/nr_requests ] && echo "echo `cat /sys/block/sda/queue/nr_requests` > /sys/block/sda/queue/nr_requests" >> $BACKUP;
[ -e /sys/block/sde/queue/nr_requests ] && echo "echo `cat /sys/block/sde/queue/nr_requests` > /sys/block/sde/queue/nr_requests" >> $BACKUP;
[ -e /sys/block/sda/queue/rq_affinity ] && echo "echo `cat /sys/block/sda/queue/rq_affinity` > /sys/block/sda/queue/rq_affinity" >> $BACKUP;
[ -e /sys/block/sde/queue/rq_affinity ] && echo "echo `cat /sys/block/sde/queue/rq_affinity` > /sys/block/sde/queue/rq_affinity" >> $BACKUP;
[ -e /proc/sys/vm/overcommit_memory ] && echo "echo `cat /proc/sys/vm/overcommit_memory` > /proc/sys/vm/overcommit_memory" >> $BACKUP;
[ -e /proc/sys/vm/stat_interval ] && echo "echo `cat /proc/sys/vm/stat_interval` > /proc/sys/vm/stat_interval" >> $BACKUP;
[ -e /proc/sys/vm/panic_on_oom ] && echo "echo `cat /proc/sys/vm/panic_on_oom` > /proc/sys/vm/panic_on_oom" >> $BACKUP;
[ -e /sys/kernel/mm/transparent_hugepage/enabled ] && echo "echo never > /sys/kernel/mm/transparent_hugepage/enabled" >> $BACKUP;
[ -e /sys/kernel/mm/transparent_hugepage/defrag ] && echo "echo madvise > /sys/kernel/mm/transparent_hugepage/defrag" >> $BACKUP;
[ -e /sys/kernel/mm/transparent_hugepage/khugepaged/max_ptes_swap ] && echo "echo `cat /sys/kernel/mm/transparent_hugepage/khugepaged/max_ptes_swap` > /sys/kernel/mm/transparent_hugepage/khugepaged/max_ptes_swap" >> $BACKUP;
[ -n `settings get global zram_enabled` ] && echo "settings put global zram_enabled `settings get global zram_enabled`" >> $BACKUP;
[ -e /sys/module/dm_bufio/parameters/max_cache_size_bytes ] && echo "echo `cat /sys/module/dm_bufio/parameters/max_cache_size_bytes` > /sys/module/dm_bufio/parameters/max_cache_size_bytes" >> $BACKUP;
[ -e /sys/module/dm_bufio/parameters/peak_allocated_bytes ] && echo "echo `cat /sys/module/dm_bufio/parameters/peak_allocated_bytes` > /sys/module/dm_bufio/parameters/peak_allocated_bytes" >> $BACKUP;
[ -e /proc/sys/vm/vfs_cache_pressure ] && echo "echo `cat /proc/sys/vm/vfs_cache_pressure` > /proc/sys/vm/vfs_cache_pressure" >> $BACKUP;
[ -e /proc/sys/vm/watermark_scale_factor ] && echo "echo `cat /proc/sys/vm/watermark_scale_factor` > /proc/sys/vm/watermark_scale_factor" >> $BACKUP;
[ -e /proc/sys/vm/compaction_proactiveness ] && echo "echo `cat /proc/sys/vm/compaction_proactiveness` > /proc/sys/vm/compaction_proactiveness" >> $BACKUP;
[ -e /proc/sys/vm/min_free_kbytes ] && echo "echo `cat /proc/sys/vm/min_free_kbytes` > /proc/sys/vm/min_free_kbytes" >> $BACKUP;
[ -e /proc/sys/vm/swappiness ] && echo "echo `cat /proc/sys/vm/swappiness` > /proc/sys/vm/swappiness" >> $BACKUP;

# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Mounts/IO
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/io.bak
touch $BACKUP;

# write the current configurations to the backup
for queue in /sys/block/*/queue; do
    [ -e $queue/iostats ] && echo "echo `cat $queue/iostats` > $queue/iostats" >> $BACKUP;
    [ -e $queue/read_ahead_kb ] && echo "echo `cat $queue/read_ahead_kb` > $queue/read_ahead_kb" >> $BACKUP;
    [ -e $queue/nr_requests ] && echo "echo `cat $queue/nr_requests` > $queue/nr_requests" >> $BACKUP;
done
[ -e /proc/sys/fs/dir-notify-enable ] && echo "echo `cat /proc/sys/fs/dir-notify-enable` > /proc/sys/fs/dir-notify-enable" >> $BACKUP;
[ -e /proc/sys/fs/by-name/userdata/iostat_enable ] && echo "echo `cat /proc/sys/fs/by-name/userdata/iostat_enable` > /proc/sys/fs/by-name/userdata/iostat_enable" >> $BACKUP;
[ -e /sys/module/fuse/parameters/max_user_bgreq ] && echo "echo `cat /sys/module/fuse/parameters/max_user_bgreq` > /sys/module/fuse/parameters/max_user_bgreq" >> $BACKUP;
[ -e /sys/module/fuse/parameters/max_user_congthresh ] && echo "echo `cat /sys/module/fuse/parameters/max_user_congthresh` > /sys/module/fuse/parameters/max_user_congthresh" >> $BACKUP;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Run In Background
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/runinbackground.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the analytics services exist for the package
    rib_exists=$(cmd package dump $pkg | grep -i 'run_in_'); 
    rib_also_exists=$(dumpsys package $pkg | grep -i 'run_in_');
    raib_exists=$(cmd package dump $pkg | grep -i 'run_any_in_'); 
    raib_also_exists=$(dumpsys package $pkg | grep -i 'run_any_in_');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/runinbackground" ]]; then
    
        # is this packge in it?
        if [[ "$(grep -ic "$pkg" $EXCLUDESDIR/runinbackground)" -ge 1 ]]; then

            # just continue
            continue 1

        fi;

    fi;

    # see if it exists
    if [[ ! -z "$rib_exists" ]] || [[ ! -z "$rib_also_exists" ]]; then

        # write in the backup
        echo "cmd appops set $pkg RUN_IN_BACKGROUND allow;" >> $BACKUP

    fi;

    # see if it exists
    if [[ ! -z "$raib_exists" ]] || [[ ! -z "$raib_also_exists" ]]; then

        # write in the backup
        echo "cmd appops set $pkg RUN_ANY_IN_BACKGROUND allow;" >> $BACKUP

    fi;

done;

# ------------------------------------------------------------------
# - Sensor
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/sensor.bak
touch $BACKUP;

[ -n `settings get system sensor_blocked_app` ] && echo "settings put system sensor_blocked_app `settings get system sensor_blocked_app`;" >> $BACKUP;
# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Settings
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/settings.bak
touch $BACKUP;

        # write the original settings to the backup
[ -n `settings get global cached_apps_freezer` ] && echo "settings put global cached_apps_freezer `settings get global cached_apps_freezer`" >> $BACKUP;
[ -n `settings get global low_power_back_data_off` ] && echo "settings put global low_power_back_data_off `settings get global low_power_back_data_off`" >> $BACKUP;
[ -n `settings get global restricted_device_performance` ] && echo "settings put global restricted_device_performance `settings get global restricted_device_performance`" >> $BACKUP;
[ -e /sys/module/battery_saver/parameters/enabled ] && echo "echo `cat /sys/module/battery_saver/parameters/enabled` > /sys/module/battery_saver/parameters/enabled" >> $BACKUP;
[ -e /sys/module/workqueue/parameters/power_efficient ] && echo "echo `cat /sys/module/workqueue/parameters/power_efficient` > /sys/module/workqueue/parameters/power_efficient" >> $BACKUP;
[ -e /sys/devices/system/cpu/sched_mc_power_savings ] && echo "echo `cat /sys/devices/system/cpu/sched_mc_power_savings` > /sys/devices/system/cpu/sched_mc_power_savings" >> $BACKUP;
[ -e /sys/power/mem_sleep ] && echo "echo `cat /sys/power/mem_sleep` > /sys/power/mem_sleep" >> $BACKUP;
        # write the original settings to the backup
[ -n `settings get global min_refresh_rate` ] && echo "settings put global min_refresh_rate `settings get global min_refresh_rate`" >> $BACKUP;
[ -n `settings get global previous_ram_expand_size` ] && echo "settings put global previous_ram_expand_size `settings get global previous_ram_expand_size`" >> $BACKUP;
[ -n `settings get global long_press_timeout` ] && echo "settings put global long_press_timeout `settings get global long_press_timeout`" >> $BACKUP;
[ -n `settings get global multi_press_timeout` ] && echo "settings put global multi_press_timeout `settings get global multi_press_timeout`" >> $BACKUP;
[ -n `settings get global accessibility_reduce_transparency` ] && echo "settings put global accessibility_reduce_transparency `settings get global accessibility_reduce_transparency`" >> $BACKUP;
[ -n `settings get global ram_expand_size` ] && echo "settings put global ram_expand_size `settings get global ram_expand_size`" >> $BACKUP;
[ -e /dev/stune/background/schedtune.boost ] && echo "echo `cat /dev/stune/background/schedtune.boost` > /dev/stune/background/schedtune.boost" >> $BACKUP;
[ -e /dev/stune/background/schedtune.preferidle ] && echo "echo `cat /dev/stune/background/schedtune.preferidle` > /dev/stune/background/schedtune.preferidle" >> $BACKUP;
[ -e /dev/stune/foreground/schedtune.boost ] && echo "echo `cat /dev/stune/foreground/schedtune.boost` > /dev/stune/foreground/schedtune.boost" >> $BACKUP;
[ -e /dev/stune/foreground/schedtune.preferidle ] && echo "echo `cat /dev/stune/foreground/schedtune.preferidle` > /dev/stune/foreground/schedtune.preferidle" >> $BACKUP;
[ -e /dev/stune/top-app/schedtune.boost ] && echo "echo `cat /dev/stune/top-app/schedtune.boost` > /dev/stune/top-app/schedtune.boost" >> $BACKUP;
[ -e /dev/stune/top-app/schedtune.preferidle ] && echo "echo `cat /dev/stune/top-app/schedtune.preferidle` > /dev/stune/top-app/schedtune.preferidle" >> $BACKUP;
        # write the original settings to the backup
[ -n `settings get system accelerometer_rotation` ] && echo "settings put system accelerometer_rotation `settings get system accelerometer_rotation`" >> $BACKUP;
[ -n `settings get system auto_screen_on` ] && echo "settings put system auto_screen_on `settings get system auto_screen_on`" >> $BACKUP;
[ -n `settings get system blue_light_filter` ] && echo "settings put system blue_light_filter `settings get system blue_light_filter`" >> $BACKUP;
[ -n `settings get system blue_light_filter_adaptive_mode` ] && echo "settings put system blue_light_filter_adaptive_mode `settings get system blue_light_filter_adaptive_mode`" >> $BACKUP;
[ -n `settings get system display_night_theme` ] && echo "settings put system display_night_theme `settings get system display_night_theme`" >> $BACKUP;
[ -n `settings get system display_night_theme_wallpaper` ] && echo "settings put system display_night_theme_wallpaper `settings get system display_night_theme_wallpaper`" >> $BACKUP;
[ -n `settings get system screen_mode_automatic_setting` ] && echo "settings put system screen_mode_automatic_setting `settings get system screen_mode_automatic_setting`" >> $BACKUP;
[ -n `settings get system screen_off_pocket` ] && echo "settings put system screen_off_pocket `settings get system screen_off_pocket`" >> $BACKUP;
        # write the original settings to the backup
[ -n `settings get system camera_feedback_vibrate` ] && echo "settings put system camera_feedback_vibrate `settings get system camera_feedback_vibrate`" >> $BACKUP
[ -n `settings get system dialing_keypad_vibrate` ] && echo "settings put system dialing_keypad_vibrate `settings get system dialing_keypad_vibrate`" >> $BACKUP
[ -n `settings get system dtmf_tone` ] && echo "settings put system dtmf_tone `settings get system dtmf_tone`" >> $BACKUP
[ -n `settings get system lockscreen_sounds_enabled` ] && echo "settings put system lockscreen_sounds_enabled `settings get system lockscreen_sounds_enabled`" >> $BACKUP
[ -n `settings get system navigation_gestures_vibrate` ] && echo "settings put system navigation_gestures_vibrate `settings get system navigation_gestures_vibrate`" >> $BACKUP
[ -n `settings get system SEM_VIBRATION_FORCE_TOUCH_INTENSITY` ] && echo "settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY `settings get system SEM_VIBRATION_FORCE_TOUCH_INTENSITY`" >> $BACKUP
[ -n `settings get system SEM_VIBRATION_NOTIFICATION_INTENSITY` ] && echo "settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY `settings get system SEM_VIBRATION_NOTIFICATION_INTENSITY`" >> $BACKUP
[ -n `settings get system SEM_VIBRATION_RING_INTENSITY` ] && echo "settings put system SEM_VIBRATION_RING_INTENSITY `settings get system SEM_VIBRATION_RING_INTENSITY`" >> $BACKUP
[ -n `settings get system sound_effects_enabled` ] && echo "settings put system sound_effects_enabled `settings get system sound_effects_enabled`" >> $BACKUP
[ -n `settings get system sync_vibration_with_notification` ] && echo "settings put system sync_vibration_with_notification `settings get system sync_vibration_with_notification`" >> $BACKUP
[ -n `settings get system sync_vibration_with_ringtone` ] && echo "settings put system sync_vibration_with_ringtone `settings get system sync_vibration_with_ringtone`" >> $BACKUP
[ -n `settings get system vibrate_when_ringing` ] && echo "settings put system vibrate_when_ringing `settings get system vibrate_when_ringing`" >> $BACKUP
[ -n `settings get system vibration_sound_enabled` ] && echo "settings put system vibration_sound_enabled `settings get system vibration_sound_enabled`" >> $BACKUP
[ -n `settings get system VIB_FEEDBACK_MAGNITUDE` ] && echo "settings put system VIB_FEEDBACK_MAGNITUDE `settings get system VIB_FEEDBACK_MAGNITUDE`" >> $BACKUP
[ -n `settings get system VIB_RECVCALL_MAGNITUDE` ] && echo "settings put system VIB_RECVCALL_MAGNITUDE `settings get system VIB_RECVCALL_MAGNITUDE`" >> $BACKUP
[ -n `settings get secure charging_sounds_enabled` ] && echo "settings put secure charging_sounds_enabled `settings get secure charging_sounds_enabled`" >> $BACKUP
[ -n `settings get secure charging_vibration_enabled` ] && echo "settings put secure charging_vibration_enabled `settings get secure charging_vibration_enabled`" >> $BACKUP
[ -n `settings get global dock_sounds_enabled` ] && echo "settings put global dock_sounds_enabled `settings get global dock_sounds_enabled`" >> $BACKUP
[ -n `settings get global emergency_tone` ] && echo "settings put global emergency_tone `settings get global emergency_tone`" >> $BACKUP
[ -n `settings get global power_sounds_enabled` ] && echo "settings put global power_sounds_enabled `settings get global power_sounds_enabled`" >> $BACKUP
        # write the original settings to the backup
[ -n `settings get system mcf_continuity` ] && echo "settings put system mcf_continuity `settings get system mcf_continuity`" >> $BACKUP
[ -n `settings get system master_motion` ] && echo "settings put system master_motion `settings get system master_motion`" >> $BACKUP
[ -n `settings get system motion_engine` ] && echo "settings put system motion_engine `settings get system motion_engine`" >> $BACKUP
[ -n `settings get system motion_pick_up` ] && echo "settings put system motion_pick_up `settings get system motion_pick_up`" >> $BACKUP
[ -n `settings get system air_motion_engine` ] && echo "settings put system air_motion_engine `settings get system air_motion_engine`" >> $BACKUP
[ -n `settings get system air_motion_wake_up` ] && echo "settings put system air_motion_wake_up `settings get system air_motion_wake_up`" >> $BACKUP
[ -n `settings get secure adaptive_sleep` ] && echo "settings put secure adaptive_sleep `settings get secure adaptive_sleep`" >> $BACKUP
[ -n `settings get secure aware_enabled` ] && echo "settings put secure aware_enabled `settings get secure aware_enabled`" >> $BACKUP
[ -n `settings get secure back_gesture_inset_scale_left` ] && echo "settings put secure back_gesture_inset_scale_left `settings get secure back_gesture_inset_scale_left`" >> $BACKUP
[ -n `settings get secure back_gesture_inset_scale_right` ] && echo "settings put secure back_gesture_inset_scale_right `settings get secure back_gesture_inset_scale_right`" >> $BACKUP
[ -n `settings get secure emergency_gesture_enabled` ] && echo "settings put secure emergency_gesture_enabled `settings get secure emergency_gesture_enabled`" >> $BACKUP
[ -n `settings get secure hush_gesture_used` ] && echo "settings put secure hush_gesture_used `settings get secure hush_gesture_used`" >> $BACKUP
[ -n `settings get secure silence_gesture` ] && echo "settings put secure silence_gesture `settings get secure silence_gesture`" >> $BACKUP
[ -n `settings get secure skip_gesture` ] && echo "settings put secure skip_gesture `settings get secure skip_gesture`" >> $BACKUP
[ -n `settings get secure volume_hush_gesture` ] && echo "settings put secure volume_hush_gesture `settings get secure volume_hush_gesture`" >> $BACKUP
[ -n `settings get global ambient_enabled` ] && echo "settings put global ambient_enabled `settings get global ambient_enabled`" >> $BACKUP
[ -n `settings get global ambient_tilt_to_wake` ] && echo "settings put global ambient_tilt_to_wake `settings get global ambient_tilt_to_wake`" >> $BACKUP
[ -n `settings get global ambient_touch_to_wake` ] && echo "settings put global ambient_touch_to_wake `settings get global ambient_touch_to_wake`" >> $BACKUP
[ -n `settings get global enable_back_animation` ] && echo "settings put global enable_back_animation `settings get global enable_back_animation`" >> $BACKUP
        # write out the backup settings
[ -n `settings get system direct_share` ] && echo "settings put system direct_share `settings get system direct_share`" >> $BACKUP;
[ -n `settings get system gearhead:driving_mode_settings_enabled` ] && echo "settings put system gearhead:driving_mode_settings_enabled `settings get system gearhead:driving_mode_settings_enabled`" >> $BACKUP;
[ -n `settings get secure smartspace` ] && echo "settings put secure smartspace `settings get secure smartspace`" >> $BACKUP;
[ -n `settings get global google_core_control` ] && echo "settings put global google_core_control `settings get global google_core_control`" >> $BACKUP;
        # write out the backup settings
[ -n `settings get system add_info_alarm` ] && echo "settings put system add_info_alarm `settings get system add_info_alarm`" >> $BACKUP
[ -n `settings get system add_info_today_schedule` ] && echo "settings put system add_info_today_schedule `settings get system add_info_today_schedule`" >> $BACKUP
[ -n `settings get system add_info_music_control` ] && echo "settings put system add_info_music_control `settings get system add_info_music_control`" >> $BACKUP
[ -n `settings get system facewidget_music_transparency` ] && echo "settings put system facewidget_music_transparency `settings get system facewidget_music_transparency`" >> $BACKUP
[ -n `settings get system lockstar_enabled` ] && echo "settings put system lockstar_enabled `settings get system lockstar_enabled`" >> $BACKUP
[ -n `settings get system lock_editor_support_touch_hold` ] && echo "settings put system lock_editor_support_touch_hold `settings get system lock_editor_support_touch_hold`" >> $BACKUP
[ -n `settings get system lock_noticard_opacity` ] && echo "settings put system lock_noticard_opacity `settings get system lock_noticard_opacity`" >> $BACKUP
[ -n `settings get system screen_transition_effect` ] && echo "settings put system screen_transition_effect `settings get system screen_transition_effect`" >> $BACKUP
[ -n `settings get secure lock_screen_show_notifications` ] && echo "settings put secure lock_screen_show_notifications `settings get secure lock_screen_show_notifications`" >> $BACKUP
[ -n `settings get secure lock_screen_lock_after_timeout` ] && echo "settings put secure lock_screen_lock_after_timeout `settings get secure lock_screen_lock_after_timeout`" >> $BACKUP
[ -n `settings get secure lock_screen_owner_info_enabled` ] && echo "settings put secure lock_screen_owner_info_enabled `settings get secure lock_screen_owner_info_enabled`" >> $BACKUP
        # write out the backup settings
[ -n `settings get global ble_scan_always_enabled` ] && echo "settings put global ble_scan_always_enabled `settings get global ble_scan_always_enabled`" >> $BACKUP;
[ -n `settings get global default_restrict_background_data` ] && echo "settings put global default_restrict_background_data `settings get global default_restrict_background_data`" >> $BACKUP;
[ -n `settings get global mobile_signal_detector` ] && echo "settings put global mobile_signal_detector `settings get global mobile_signal_detector`" >> $BACKUP;
[ -n `settings get global network_recommendations_enabled` ] && echo "settings put global network_recommendations_enabled `settings get global network_recommendations_enabled`" >> $BACKUP;
[ -n `settings get global network_scoring_ui_enabled` ] && echo "settings put global network_scoring_ui_enabled `settings get global network_scoring_ui_enabled`" >> $BACKUP;
[ -n `settings get global swipe_to_call_message` ] && echo "settings put global swipe_to_call_message `settings get global swipe_to_call_message`" >> $BACKUP;
        # write out the original settings
[ -n `settings get secure screensaver_enabled` ] && echo "settings put secure screensaver_enabled `settings get secure screensaver_enabled`" >> $BACKUP;
[ -n `settings get secure screensaver_activate_on_sleep` ] && echo "settings put secure screensaver_activate_on_sleep `settings get secure screensaver_activate_on_sleep`" >> $BACKUP;
[ -n `settings get secure screensaver_activate_on_dock` ] && echo "settings put secure screensaver_activate_on_dock `settings get secure screensaver_activate_on_dock`" >> $BACKUP;
        # write out the original settings
[ -n `settings get system access_control_enabled` ] && echo "settings put system access_control_enabled `settings get system access_control_enabled`" >> $BACKUP;
[ -n `settings get system android.wallpaper.settings_systemui_transparency` ] && echo "settings put system android.wallpaper.settings_systemui_transparency `settings get system android.wallpaper.settings_systemui_transparency`" >> $BACKUP;
[ -n `settings get system Flashlight_brightness_level` ] && echo "settings put system Flashlight_brightness_level `settings get system Flashlight_brightness_level`" >> $BACKUP;
[ -n `settings get system nearby_scanning_enabled` ] && echo "settings put system nearby_scanning_enabled `settings get system nearby_scanning_enabled`" >> $BACKUP;
[ -n `settings get system people_stripe` ] && echo "settings put system people_stripe `settings get system people_stripe`" >> $BACKUP;
[ -n `settings get system security_policy_update` ] && echo "settings put system security_policy_update `settings get system security_policy_update`" >> $BACKUP;
[ -n `settings get system send_security_reports` ] && echo "settings put system send_security_reports `settings get system send_security_reports`" >> $BACKUP;
[ -n `settings get secure backup_enabled` ] && echo "settings put secure backup_enabled `settings get secure backup_enabled`" >> $BACKUP;
[ -n `settings get secure clipboard_show_access_notifications` ] && echo "settings put secure clipboard_show_access_notifications `settings get secure clipboard_show_access_notifications`" >> $BACKUP;
[ -n `settings get secure notification_badging` ] && echo "settings put secure notification_badging `settings get secure notification_badging`" >> $BACKUP;
[ -n `settings get secure notification_bubbles` ] && echo "settings put secure notification_bubbles `settings get secure notification_bubbles`" >> $BACKUP;
[ -n `settings get secure show_notification_snooze` ] && echo "settings put secure show_notification_snooze `settings get secure show_notification_snooze`" >> $BACKUP;
[ -n `settings get secure spell_checker_enabled` ] && echo "settings put secure spell_checker_enabled `settings get secure spell_checker_enabled`" >> $BACKUP;
[ -n `settings get secure user_full_data_backup_aware` ] && echo "settings put secure user_full_data_backup_aware `settings get secure user_full_data_backup_aware`" >> $BACKUP;
[ -n `settings get global assisted_gps_enabled` ] && echo "settings put global assisted_gps_enabled `settings get global assisted_gps_enabled`" >> $BACKUP;
[ -n `settings get global bug_report` ] && echo "settings put global bug_report `settings get global bug_report`" >> $BACKUP;
[ -n `settings get global master_sync_status` ] && echo "settings put global master_sync_status `settings get global master_sync_status`" >> $BACKUP;
[ -n `settings get global retail_mode` ] && echo "settings put global retail_mode `settings get global retail_mode`" >> $BACKUP;
[ -n `settings get global screen_call` ] && echo "settings put global screen_call `settings get global screen_call`" >> $BACKUP;
[ -n `settings get global send_action_app_error` ] && echo "settings put global send_action_app_error `settings get global send_action_app_error`" >> $BACKUP;
[ -n `settings get global uwb_enabled` ] && echo "settings put global uwb_enabled `settings get global uwb_enabled`" >> $BACKUP;
[ -n `settings get global wait_for_debugger` ] && echo "settings put global wait_for_debugger `settings get global wait_for_debugger`" >> $BACKUP;
        # write out the original settings
[ -n `settings get secure multi_control_connection_state` ] && echo "settings put secure multi_control_connection_state `settings get secure multi_control_connection_state`" >> $BACKUP;
[ -n `settings get secure wifi_adps_enable` ] && echo echo "settings put secure wifi_adps_enable `settings get secure wifi_adps_enable`" >> $BACKUP;
[ -n `settings get secure tap_duration_threshold` ] && echo echo "settings put secure tap_duration_threshold `settings get secure tap_duration_threshold`" >> $BACKUP;
[ -n `settings get secure touch_blocking_period` ] && echo echo "settings put secure touch_blocking_period `settings get secure touch_blocking_period`" >> $BACKUP;
        # write out the original settings
[ -n `settings get global auto_wifi` ] && echo "settings put global auto_wifi `settings get global auto_wifi`" >> $BACKUP;
[ -n `settings get global sem_wifi_network_rating_scorer_enabled` ] && echo "settings put global sem_wifi_network_rating_scorer_enabled `settings get global sem_wifi_network_rating_scorer_enabled`" >> $BACKUP;
[ -n `settings get global sem_wifi_switch_to_better_wifi_enabled`] && echo "settings put global sem_wifi_switch_to_better_wifi_enabled `settings get global sem_wifi_switch_to_better_wifi_enabled`" >> $BACKUP;
[ -n `settings get global sem_wifi_switch_to_better_wifi_supported` ] && echo "settings put global sem_wifi_switch_to_better_wifi_supported `settings get global sem_wifi_switch_to_better_wifi_supported`" >> $BACKUP;
[ -n `settings get global wifi_networks_available_notification_on` ] && echo "settings put global wifi_networks_available_notification_on `settings get global wifi_networks_available_notification_on`" >> $BACKUP;
[ -n `settings get global wifi_scan_always_enabled` ] && echo "settings put global wifi_scan_always_enabled `settings get global wifi_scan_always_enabled`" >> $BACKUP;
        # write out the original settings
[ -n `settings get global package_verifier_user_consent` ] && echo "settings put global package_verifier_user_consent `settings get global package_verifier_user_consent`" >> $BACKUP; 
        # write out the original settings
[ -n `settings get secure masterLocationPackagePrefixBlacklist` ] && echo "settings put secure masterLocationPackagePrefixBlacklist `settings get secure masterLocationPackagePrefixBlacklist`" >> $BACKUP;
[ -n `settings get secure masterLocationPackagePrefixWhitelist` ] && echo "settings put secure masterLocationPackagePrefixWhitelist `settings get secure masterLocationPackagePrefixWhitelist`" >> $BACKUP;
[ -n `settings get system location_ignore_settings_package_whitelist` ] && echo "settings put system location_ignore_settings_package_whitelist `settings get system location_ignore_settings_package_whitelist`" >> $BACKUP;
[ -n `settings get secure location_ignore_settings_package_whitelist` ] && echo "settings put secure location_ignore_settings_package_whitelist `settings get secure location_ignore_settings_package_whitelist`" >> $BACKUP;
[ -n `settings get global location_ignore_settings_package_whitelist` ] && echo "settings put global location_ignore_settings_package_whitelist `settings get global location_ignore_settings_package_whitelist`" >> $BACKUP;
        # write out the original settings
[ -n `settings get global window_animation_scale` ] && echo "settings put global window_animation_scale `settings get global window_animation_scale`" >> $BACKUP
[ -n `settings get global transition_animation_scale` ] && echo "settings put global transition_animation_scale `settings get global transition_animation_scale`" >> $BACKUP
[ -n `settings get global animator_duration_scale` ] && echo "settings put global animator_duration_scale `settings get global animator_duration_scale`" >> $BACKUP
[ -e /dev/stune/schedtune.boost ] && echo "echo `cat /dev/stune/schedtune.boost` > /dev/stune/schedtune.boost" >> $BACKUP
[ -e /dev/stune/schedtune.preferidle ] && echo "echo `cat /dev/stune/schedtune.preferidle` > /dev/stune/schedtune.preferidle" >> $BACKUP
        # write out the original settings
[ -n `device_config get activity_manager bg_auto_restrict_abusive_apps` ] && echo "device_config put activity_manager bg_auto_restrict_abusive_apps `device_config get activity_manager bg_auto_restrict_abusive_apps`" >> $BACKUP;
[ -n `device_config get activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled` ] && echo "device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled `device_config get activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled`" >> $BACKUP;
        # write out the original settings
[ -n $(pm path "com.google.android.apps.wellbeing" | sed 's/package://') ] && echo "pm enable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService" >> $BACKUP;
[ -n $(pm path "com.google.android.apps.wellbeing" | sed 's/package://') ] && echo "pm enable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService" >> $BACKUP;
        # write out the original settings
[ -e /proc/sys/net/core/wmem_max ] && echo "echo `cat /proc/sys/net/core/wmem_max` > /proc/sys/net/core/wmem_max" >> $BACKUP;
[ -e /proc/sys/net/core/rmem_max ] && echo "echo `cat /proc/sys/net/core/rmem_max` > /proc/sys/net/core/rmem_max" >> $BACKUP;
[ -e /proc/sys/net/core/rmem_default ] && echo "echo `cat /proc/sys/net/core/rmem_default` > /proc/sys/net/core/rmem_default" >> $BACKUP;
[ -e /proc/sys/net/core/wmem_default ] && echo "echo `cat /proc/sys/net/core/wmem_default` > /proc/sys/net/core/wmem_default" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_timestamps ] && echo "echo `cat /proc/sys/net/ipv4/tcp_timestamps` > /proc/sys/net/ipv4/tcp_timestamps" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_tw_reuse ] && echo "echo `cat /proc/sys/net/ipv4/tcp_tw_reuse` > /proc/sys/net/ipv4/tcp_tw_reuse" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_sack ] && echo "echo `cat /proc/sys/net/ipv4/tcp_sack` > /proc/sys/net/ipv4/tcp_sack" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_tw_recycle ] && echo "echo `cat /proc/sys/net/ipv4/tcp_tw_recycle` > /proc/sys/net/ipv4/tcp_tw_recycle" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_window_scaling ] && echo "echo `cat /proc/sys/net/ipv4/tcp_window_scaling` > /proc/sys/net/ipv4/tcp_window_scaling" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_keepalive_probes ] && echo "echo `cat /proc/sys/net/ipv4/tcp_keepalive_probes` > /proc/sys/net/ipv4/tcp_keepalive_probes" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_keepalive_intvl ] && echo "echo `cat /proc/sys/net/ipv4/tcp_keepalive_intvl` > /proc/sys/net/ipv4/tcp_keepalive_intvl" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_fin_timeout ] && echo "echo `cat /proc/sys/net/ipv4/tcp_fin_timeout` > /proc/sys/net/ipv4/tcp_fin_timeout" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_wmem ] && echo "echo '`cat /proc/sys/net/ipv4/tcp_wmem`' > /proc/sys/net/ipv4/tcp_wmem" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_mem ] && echo "echo '`cat /proc/sys/net/ipv4/tcp_mem`' > /proc/sys/net/ipv4/tcp_mem" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_ecn ] && echo "echo `cat /proc/sys/net/ipv4/tcp_ecn` > /proc/sys/net/ipv4/tcp_ecn" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_fastopen ] && echo "echo `cat /proc/sys/net/ipv4/tcp_fastopen` > /proc/sys/net/ipv4/tcp_fastopen" >> $BACKUP;
[ -e /proc/sys/net/ipv4/tcp_syncookies ] && echo "echo `cat /proc/sys/net/ipv4/tcp_syncookies` > /proc/sys/net/ipv4/tcp_syncookies" >> $BACKUP;

# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Tracking
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/tracking.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the analytics services exist for the package
    exists=$(cmd package dump $pkg | grep -i 'tracki' | awk -F"cmp=" '{print $2}' | tail -n 1); 
    also_exists=$(dumpsys package $pkg | grep -Eo "^[[:space:]]+[0-9a-f]+[[:space:]]+$pkg/[^[:space:]]+" | grep -oE "[^[:space:]]+$" | grep -i 'tracki');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/tracking" ]]; then
    
        # is this packge in it?
        if [[ $(grep -ic "$pkg" $EXCLUDESDIR/tracking) -ge 1 ]]; then
            continue 1
        fi;

    fi;

    # see if it exists
    if [[ ! -z "${exists// }" ]]; then

        # write the enable command to our backup file
        echo "pm enable $exists;" >> $BACKUP

    fi;

    # now we need to split also_exists into multiple lines
    also_exists_here="${also_exists// /$'\n'}";

    # loop it
    for e in $also_exists_here;
    do
    
        echo "pm enable $e;" >> $BACKUP

    done

done;

# ------------------------------------------------------------------
# ------------------------------------------------------------------

# ------------------------------------------------------------------
# - Wake Lock
# ------------------------------------------------------------------
# hold the backup file
BACKUP=$BACKUPDIR/wakelock.bak
touch $BACKUP;

# loop over all packages
for pkg in $PACKAGES; 
do

    # see if the analytics services exist for the package
    exists=$(cmd package dump $pkg | grep -i 'wake_l'); 
    also_exists=$(dumpsys package $pkg | grep -i 'wake_l');

    # does the exclusion list exist?
    if [[ -e "$EXCLUDESDIR/wakelock" ]]; then
    
        # is this packge in it?
        if [[ "$(grep -ic "$pkg" $EXCLUDESDIR/wakelock)" -ge 1 ]]; then

            # just continue
            continue 1

        fi;

    fi;

    # see if it exists
    if [[ ! -z "$exists" ]] || [[ ! -z "$also_exists" ]]; then

        echo "cmd appops set $pkg WAKE_LOCK allow;" >> $BACKUP

    fi;

done;

# ------------------------------------------------------------------
# ------------------------------------------------------------------
