#!/system/bin/sh

# our module's directory
MODDIR=${0%/*}

# our backup directory
BACKUPDIR=$MODDIR/backup

# hold the log file
THELOG=$MODDIR/log.txt

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# clear the log file before anything else.  This happens every boot
> $THELOG;

(

    # Get a list of packages, uniquely sorted
    PACKAGES=$(pm list packages -f | sed -e 's/.*=//' | uniq | sort);

    # Get a list of user installed packages, uniquely sorted
    USER_PACKAGES=$(pm list packages -3 | sed 's/^package://' | uniq | sort);

    # setup busybox
    ASH_STANDALONE=1
    BB=/data/adb/magisk/busybox;

    # export the moddir so we have access to it throughout
    export MODDIR;

    # export the backup directory so we have access to it throughout
    export BACKUPDIR;

    # export the package list so it's available across everything
    export PACKAGES;

    # export the user packages for it's available across everything
    export USER_PACKAGES;

    # so we can use it elsewhere
    export BB;

    # check if the debug file exists
    if [[ -f "$MODDIR/tdp-debug" ]]; then

        # it does, so log everything in here
        exec > >(tee -a "$THELOG") 2>&1

    fi;

    # if we're tweaking the kernel
    if [[ -f "$MODDIR/tdp-kernel" ]]; then

        # include our kernel tweaks
        source $MODDIR/includes/kernel.sh

    fi;

    # if we're tweaking the settings
    if [[ -f "$MODDIR/tdp-settings" ]]; then

        # include our settings tweaks
        source $MODDIR/includes/settings.sh

    fi;

    # if we're disabling the analytics
    if [[ -f "$MODDIR/tdp-analytics" ]]; then

        # include our analytics disabler
        source $MODDIR/includes/analytics.sh

    fi;

    # if we're disabling the diagnostics
    if [[ -f "$MODDIR/tdp-diagnostics" ]]; then

        # include our diagnostics disabler
        source $MODDIR/includes/diagnostics.sh

    fi;

    # if we're disabling the adservices
    if [[ -f "$MODDIR/tdp-adservices" ]]; then

        # include our adservices disabler
        source $MODDIR/includes/adservices.sh

    fi;

    # if we're disabling the tracking
    if [[ -f "$MODDIR/tdp-tracking" ]]; then

        # include our tracking disabler
        source $MODDIR/includes/tracking.sh

    fi;

    # if we're running the compiler
    if [[ -f "$MODDIR/tdp-compiler" ]]; then

        # include our compilerr
        source $MODDIR/includes/compiler.sh

    fi;

    # if we're running the memory holder
    if [[ -f "$MODDIR/tdp-memory" ]]; then

        # include our memory holder
        source $MODDIR/includes/memory.sh

    fi;

    # if we're running the dozing holder
    if [[ -f "$MODDIR/tdp-dozing" ]]; then

        # include our dozing holder
        source $MODDIR/includes/dozing.sh

    fi;

    # if we're running the debugging holder
    if [[ -f "$MODDIR/tdp-debugging" ]]; then

        # include our debugging holder
        source $MODDIR/includes/debugging.sh

    fi;

    # if we're running the sensor holder
    if [[ -f "$MODDIR/tdp-sensor" ]]; then

        # include our debugging holder
        source $MODDIR/includes/sensor.sh

    fi;

    # sync then trim the partitions
    $BB sync

    # trim every boot
    $BB fstrim -v /data 
    $BB fstrim -v /system 
    $BB fstrim -v /cache 
    $BB fstrim -v /vendor 
    $BB fstrim -v /product 
    $BB fstrim -v /preload 
    $BB fstrim -v /metadata 
    $BB fstrim -v /odm 
    $BB fstrim -v /system_ext

) &
