#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/sensor.bak

    # write in our "backup"
    $BB echo "settings put system sensor_blocked_app `settings get system sensor_blocked_app`;" >> $BACKUP;

    echo `date`;
    echo " --- Starting TDP Sensor Blocker ---"

    # hold the packages
    THE_PKGS=$PACKAGES

    # loop over all user installed packages
    for pkg in $PACKAGES; 
    do

        # does the exclusion list exist?
        if [[ -f "$MODDIR/tdp-exclude" ]]; then 
        
            # is this packge in it?
            if [[ "$(grep -ic "$pkg" $MODDIR/tdp-exclude)" -ge 1 ]]; then

                # log it
                echo " Package: $pkg is excluded"

                # remove the package from the package list
                THE_PKGS=$(echo $THE_PKGS | xargs | sed -e "s/$pkg//g")

            fi;

        fi;

    done

    # now create the comma-delimited list we need for this
    THE_PKGS=$(echo $THE_PKGS | xargs | sed -e 's/ /,/g')

    # disable the packages sensors
    settings put system sensor_blocked_app $THE_PKGS;
    echo "settings put system sensor_blocked_app $THE_PKGS;";

    echo `date`;
    echo " --- Ending TDP Sensor Blocker ---"

    # make this script sleep for 4 hours
    sleep 4h

done
) & 
