#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/memory.bak

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Memory Holder ---"

     # hold the configured package string
    HELDPKGS=$(cat $MODDIR/tdp-memory | xargs | sed -e 's/ /,/g')

    # loop over the configured packages
    for pkg in $(echo $HELDPKGS | sed "s/,/ /g"); 
    do

        # unsuspending and marking the package active
        echo "Holding: $pkg in memory..."
        pm unsuspend $pkg;
        am set-inactive $pkg false;

        # write out the memory hold
        $BB echo "pm suspend $pkg;" >> $BACKUP;
        $BB echo "am set-inactive $pkg true;" >> $BACKUP;

    done;

    # write the original values
    $BB echo "echo `cat /sys/kernel/mm/swap/vma_ra_enabled` > /sys/kernel/mm/swap/vma_ra_enabled" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/page-cluster` > /proc/sys/vm/page-cluster" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/compact_unevictable_allowed` > /proc/sys/vm/compact_unevictable_allowed" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/extfrag_threshold` > /proc/sys/vm/extfrag_threshold" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sda/queue/read_ahead_kb` > /sys/block/sda/queue/read_ahead_kb" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sde/queue/read_ahead_kb` > /sys/block/sde/queue/read_ahead_kb" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sda/queue/nr_requests` > /sys/block/sda/queue/nr_requests" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sde/queue/nr_requests` > /sys/block/sde/queue/nr_requests" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sda/queue/rq_affinity` > /sys/block/sda/queue/rq_affinity" >> $BACKUP;
    $BB echo "echo `cat /sys/block/sde/queue/rq_affinity` > /sys/block/sde/queue/rq_affinity" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/overcommit_memory` > /proc/sys/vm/overcommit_memory" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/stat_interval` > /proc/sys/vm/stat_interval" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/page-cluster` > /proc/sys/vm/page-cluster" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/vm/panic_on_oom` > /proc/sys/vm/panic_on_oom" >> $BACKUP;
    $BB echo "settings put global zram_enabled `settings get global zram_enabled`" >> $BACKUP;

    # tweak the way the kernel utilizes virtual memory
    $BB echo true > /sys/kernel/mm/swap/vma_ra_enabled
    $BB echo 2 /proc/sys/vm/page-cluster
    $BB echo 0 /proc/sys/vm/compact_unevictable_allowed
    $BB echo 500 /proc/sys/vm/extfrag_threshold
    $BB echo 10 > /proc/sys/vm/stat_interval
    $BB echo 0 > /proc/sys/vm/page-cluster
    $BB echo 0 > /proc/sys/vm/panic_on_oom
    $BB echo 3 > /proc/sys/vm/drop_caches
    settings put global zram_enabled 0

    # tweak some block memory usages
    $BB echo 256 > /sys/block/sda/queue/read_ahead_kb
    $BB echo 256 > /sys/block/sde/queue/read_ahead_kb
    $BB echo 128 > /sys/block/sda/queue/nr_requests
    $BB echo 128 > /sys/block/sde/queue/nr_requests
    $BB echo 2 > /sys/block/sda/queue/rq_affinity
    $BB echo 2 > /sys/block/sde/queue/rq_affinity
    $BB echo 0 > /proc/sys/vm/overcommit_memory

    echo `date`;
    echo " --- Ending TDP Memory Holder ---"

    # make this script sleep for 4 hours
    sleep 4h

done
) &
