#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/dozing.bak

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Dozing ---"

     # hold the configured package string
    HELDPKGS=$(cat $MODDIR/tdp-dozing | xargs | sed -e 's/ /,/g')

    # loop over the configured packages
    for pkg in $(echo $HELDPKGS | sed "s/,/ /g"); 
    do

        # hold the actual package
        the_pkg=$(echo $pkg | sed "s/+//g");
        the_pkg=$(echo $the_pkg | sed "s/-//g");

        # if the app is whitelisted
        if [[ "$pkg" == *"+"* ]]; then 

            # wakeup the package from standby
            am set-inactive $the_pkg false

            # add the package to the whitelist
            dumpsys deviceidle whitelist "+$the_pkg";

            # echo out the reverse to the backup
            $BB echo "am set-inactive $the_pkg true" >> $BACKUP;
            $BB echo "dumpsys deviceidle whitelist -$the_pkg" >> $BACKUP;
            
                    
        fi;

        # if the app is blacklisted
        if [[ "$pkg" == *"-"* ]]; then 

            # wakeup the package from standby
            am set-inactive $the_pkg true

            # remove the package from the whitelist
            dumpsys deviceidle whitelist "-$the_pkg";

            # echo out the reverse to the backup
            $BB echo "am set-inactive $the_pkg false" >> $BACKUP;
            $BB echo "dumpsys deviceidle whitelist +$the_pkg" >> $BACKUP;
                    
        fi;

    done;

    echo `date`;
    echo " --- Ending TDP Dozing ---"

    # make this script sleep for 4 hours
    sleep 4h

done
) &

# run the entire bit in the background
(

    # we need to get all these settings and echo them out to our backup
    $BB echo "settings put secure doze_always_on `settings get secure doze_always_on`;" >> $BACKUP;
    $BB echo "settings put global device_idle_constants `settings get global device_idle_constants`" >> $BACKUP;
    $BB echo "device_config set_sync_disabled_for_tests none" >> $BACKUP;
    # We're done here... with the NONE above, everything else will revert to default settings

    echo " TDP Dozing Tweaks ---"
    settings put secure doze_always_on 1
    settings delete global device_idle_constants
    settings put global device_idle_constants inactive_to=300000,motion_inactive_to=120000,idle_after_inactive_to=300000,locating_to=10000,light_idle_to=300000,light_max_idle_to=600000,min_time_to_alarm=600000,idle_pending_factor=3.0,idle_factor=3.0
    device_config set_sync_disabled_for_tests persistent
    device_config put device_idle inactive_to 300000
    device_config put device_idle motion_inactive_to 120000
    device_config put device_idle idle_after_inactive_to 300000
    device_config put device_idle locating_to 10000
    device_config put device_idle light_idle_to 300000
    device_config put device_idle light_max_idle_to 600000
    device_config put device_idle min_time_to_alarm 600000
    device_config put device_idle idle_pending_factor 3.0
    device_config put device_idle idle_factor 3.0

    # disable the idler to ensure everything sticks
    dumpsys deviceidle disable all
    sleep 1 # sleep for a second

    # re-enable the idler
    dumpsys deviceidle enable all
    dumpsys deviceidle force-idle

) &
