# TDP Tweaks by kevp75
## Details
* **Version:** 1.8.89
* **Platform API:** 32+
* **Android Version:** 12L+
* **Magisk Version:** 24.2+
* **Source Code:** https://gitlab.com/kp-development/android/tdp-tweaks.git 

This is a Magisk module that attempts to modify some settings and tweak some services for better device performance, better battery management, and better privacy.

It modifies some system settings, and then attempts to disable analytics services, ad services, diagnostic services, and tracking services.  Due to the nature of these services, the disabler will run every 4 hours based on the time you last rebooted your device.

If you need help/support with this module, you will need to turn on debugging.  The module will pick this up and start logging on it's next run.  If you need the log right away, reboot your device after creating it.

Everything except the kernel tweaks should work on any device on Android 12 and up, though I only have a Pixel 6 Pro, so I am only able to test them out on that.  Your mileage may very, but if you have something else, and it works on that, please make sure to let me know.

**NOTE:**  I cannot be held responsible for bricks, world takeovers, or nuclear warfare.  As such, installing this mod is completely on you.  If you do not want this, do not flash it.

## Requirements
* **Platform API:** 32+
* **Android Version:** 12L+
* **Magisk Version:** 24.2+

## Install

1. Download the zip file, and open Magisk.
    * You can find it here: https://gitlab.com/kp-development/android/tdp-tweaks/-/releases/
2. Tap on Modules
3. Tap 'Install from storage' and browse to where you downloaded the zip file to.
4. Tap 'Ok'
5. Reboot
6. Sit back and enjoy your device

## Settings

There officially are no settings, because this is only a set of shell scripts.  Albeit, I did put in some logic to check for certain files in the mods directory to turn on/off some of them, as well, as exclude some packages and enable debugging... so ... follow along.

1. `/data/adb/modules/tdp-tweaks/tdp-debug`: This file will enable logging of all actions to the following location: `/data/adb/modules/tdp-tweaks/log.txt` If you have any issues with this module, I will be asking you for this log file...
    * Remove the file to turn this off
2. `/data/adb/modules/tdp-tweaks/tdp-excludes`: This file will be read line-by-line in order to exclude packages from the "disabler" scripts.  If you find some apps no longer work for you, you may want to add them in here to be skipped over...
    * This file is empty by default
3. `/data/adb/modules/tdp-tweaks/tdp-settings`: This file will enable some system settings tweaks.
    * This file is included by default
    * Remove this file to turn this off
    * The following sections are enabled by default.  Remove the line if you want to disable one
        * `battery`: enables the battery tweaks
        * `performance`: enables the performance tweaks
        * `display`: enables the display tweaks
        * `feedback`: enables the feedback tweaks
        * `gesture`: enables the gesture tweaks
        * `googleservice`: enables the google service tweaks
        * `gmsintent`: enables the GMS tweaks
        * `googlesystem`: enables the google system update tweaks
        * `lockscreen`: enables the lockscreen tweaks
        * `telephony`: enables the telephony tweaks
        * `screensaver`: enables the screensaver tweaks
        * `settings`: enables the system settings tweaks
        * `security`: enables the security tweaks
        * `wifi`: enables the wifi tweaks
        * `packageverifier`: enables the package verifier tweaks
        * `location`: enables the location service tweaks
        * `animation`: enables faster animations
        * `abusiveapps`: enables the abusive apps tweaks
        * `wellbeing`: enables the wellbeing tweaks
        * `network`: enables the networking tweaks
        * `filesystem`: enables the filesystem tweaks
4. `/data/adb/modules/tdp-tweaks/tdp-kernel`: This file will enable some kernel tweaks.
    * Remove this file to turn this off
5. `/data/adb/modules/tdp-tweaks/tdp-analytics`: This file will enable the analytics disabler.
    * Remove this file to turn this off
6. `/data/adb/modules/tdp-tweaks/tdp-diagnostics`: This file will enable the diagnostics disabler.
    * Remove this file to turn this off
7. `/data/adb/modules/tdp-tweaks/tdp-adservices`: This file will enable the ad services disabler.
    * Remove this file to turn this off
8. `/data/adb/modules/tdp-tweaks/tdp-tracking`: This file will enable the tracking disabler.
    * Remove this file to turn this off
8. `/data/adb/modules/tdp-tweaks/tdp-sensor`: This file will enable the sensor disabler.
    * Remove this file to turn this off
9. `/data/adb/modules/tdp-tweaks/tdp-memory`: This file will enable the memory holder.
    * Remove this file to turn this off
    * Add packages to this file to have them held in memory, for example: `com.android.launcher`
10. `/data/adb/modules/tdp-tweaks/tdp-dozing`: This file will enable the dozing tweaks.
    * Remove this file to turn this off
    * Add packages to this file to have them whitelisted or blacklisted from dozing
        * Whitelist Example: `+com.android.launcher`
        * Blacklist Example: `-com.android.launcher`
11. `/data/adb/modules/tdp-tweaks/tdp-debugging`: This file will enable the debugging disabler.
    * Remove this file to turn this off

## Requesting Support

First things first, I do this for myself and no-one else, and have simply decided to share it.  I don't owe you anything, so if you demand anything from me, you will either be ignored, or reported, or both.

Thus said, I cannot help without logs, so make sure that when you ask for help that you have turned on debugging for it (see above), you post the log.  At the very least I will need a Magisk log, which you can find in the management app.  Also helpful would be the log this module writes to (if you have enabled debugging)... it is located here: `/data/adb/modules/tdp-tweaks/log.txt`.  Also helpful would be a logcat, please google how to get this, as I will not hold anyones hand.

You can either file an issue in my repo, or reply to the thread on XDA.

## Bootlooping

This is actually pretty easy to recover from. If it happens to you, please follow these steps to recover... also note, this does not just go for my module, but any module that you may end up bootlooping with.

1. Hold your power button until you power off.
2. Once your device is off, press the power button and when the boot animation starts, press and hold your volume down, and keep holding it until it boots.
3. Once  you are in Safe Mode (you will know as your homescreen will show it), simply reboot your device.  Magisk detects safe mode and disables all modules.

Please note, and this is very important: **YMMV**

This process may be different for your device, but there is this great thing called the internet, and that can help you.  Here: https://www.google.com/search?q=how+do+I+boot+my+android+phone+into+safe+mode 

## Donations
Always welcomed, never required.

If you do decide to donate, please accept my thanks as I lift the beer(s) you bought to toast you :)

Donations can be processed here: https://www.paypal.com/cgi-bin/webscr?cmd=_s-xclick&hosted_button_id=QTT7BM7SQG46G

## Release Notes

### v. 1.8.89
* **Update:** Commands to utilize the newest package manager
    * Changes requirement to at least API 32
* **Add:** Backup methodologies
    * Creates a new folder containing backups scripts to undo everything set
    * Backups scripts will be utilized with the uninstaller to undo everything done in these tweaks
* **Add:** Filesystem tweaks, see above to enable
* **Add:** Debugging disabler, see above for more information
* **Update:** Reworked how the Doze module works, to accomodate for the backup
* Some minor performance tweaks to the scripts
* **Add:** Busybox from Osmosis
    * Latest version in Magisk has a bug and is unusable
* **Add:** Add sensor disabler curtesy of: @primeprimes :)
    * See above to configure

### v. 1.6.12
* **Fix:** Memory module. Now properly holds packages in memory, also the package will be whitelisted from dozing
    * Ensures the package really does indeed get held in memory, since this is the case, it should also not doze
* **Remove:** Default packages from the memory module
* **Add:** Dozing module.
    * Removed from settings, and moved to it's own module
    * See notes about it above for how to configure it

### v. 1.5.87
* **Removed:** Some system settings deletions that were causing spam calls to come through after setting them to blocked
* **Add:** A couple performance build.prop tweaks
    * force opengl and VSYNC
* **Add:** A newer way to hold apps in memory
    * default holds 2 packages: com.android.systemui & com.android.launcher
    * see above to add more packages

### v. 1.4.04
* **Fix:** settings tweaks... now runs every 4 hours as well.
    * yes, some do reset to default states
* **Add:** added some networking and performance tweaks
* **Add:** added some build.prop tweaks thanks to @zaidannn7
* **Removed:** Defaults
    * from now on, you need to enable these yourself.  Read the above and you will figure out how to do it.

### v. 1.3.77
* **Remove:** gmsintent tweaks
    * causing too many issues with playstore updating and installing apps
    * disabled them by default last version
* **Remove:** googlesystem tweaks
    * causing too many issues with playstore updating and installing apps
    * disabled them by default last version
* **Remove:** haptic feadback disabler
* **Added:** App battery compiler
    * changes the apps profiles from speed
    * only runs once.  If you need to run it again, remove the `/data/add/modules/tdp-tweaks/.compilerran` file and reboot
    * this can cause some issues with some apps.  If you need to undo this, simply drop a new file in the module: `/data/add/modules/tdp-tweaks/tdp-undocompile` and reboot

### v. 1.3.01
* **Fix:** better search in the disablers for package exclusions
* **Improvement:** read `tdp-settings` for enabled settings sections
    * by default all sections are enabled. 
    * to disable: 
        * first backup `/data/adb/modules/tdp-tweaks/tdp-settings` 
        * remove the setting line(s) you want to disable
            * descriptions are above
        * save the file
        * reboot
* **Fix:** disable back animation
* **Fix:** move rest of wifi tweaks to the proper section
* **Remove:** Kernel tweaks for now.
    * I want to see if I can "detect" the current scheduler and tweak based on that

### v. 1.2.78
* Initial Release
