#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/settings.bak

    # sync the filesystem
    $BB sync

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Settings Tweaks ---"

    # boost battery
    if [[ "$(grep -ic battery $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the original settings to the backup
        $BB echo "settings put global cached_apps_freezer `settings get global cached_apps_freezer`" >> $BACKUP;
        $BB echo "settings put global low_power_back_data_off `settings get global low_power_back_data_off`" >> $BACKUP;
        $BB echo "settings put global restricted_device_performance `settings get global restricted_device_performance`" >> $BACKUP;
        $BB echo "echo `cat /sys/module/battery_saver/parameters/enabled` > /sys/module/battery_saver/parameters/enabled" >> $BACKUP;
        $BB echo "echo `cat /sys/module/workqueue/parameters/power_efficient` > /sys/module/workqueue/parameters/power_efficient" >> $BACKUP;
        $BB echo "echo `cat /sys/devices/system/cpu/sched_mc_power_savings` > /sys/devices/system/cpu/sched_mc_power_savings" >> $BACKUP;
        $BB echo "echo `cat /sys/power/mem_sleep` > /sys/power/mem_sleep" >> $BACKUP;

        echo " TDP Battery Booster ---"
        settings put global cached_apps_freezer enabled
        settings put global low_power_back_data_off enabled
        settings put global restricted_device_performance 1,1
        $BB echo Y > /sys/module/battery_saver/parameters/enabled
        $BB echo Y > /sys/module/workqueue/parameters/power_efficient
        $BB echo 1 > /sys/devices/system/cpu/sched_mc_power_savings
        $BB echo deep > /sys/power/mem_sleep

    fi;

    # boost performance
    if [[ "$(grep -ic performance $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the original settings to the backup
        $BB echo "settings put global min_refresh_rate `settings get global min_refresh_rate`" >> $BACKUP;
        $BB echo "settings put global previous_ram_expand_size `settings get global previous_ram_expand_size`" >> $BACKUP;
        $BB echo "settings put global long_press_timeout `settings get global long_press_timeout`" >> $BACKUP;
        $BB echo "settings put global multi_press_timeout `settings get global multi_press_timeout`" >> $BACKUP;
        $BB echo "settings put global accessibility_reduce_transparency `settings get global accessibility_reduce_transparency`" >> $BACKUP;
        $BB echo "settings put global ram_expand_size `settings get global ram_expand_size`" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/background/schedtune.boost` > /dev/stune/background/schedtune.boost" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/background/schedtune.preferidle` > /dev/stune/background/schedtune.preferidle" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/foreground/schedtune.boost` > /dev/stune/foreground/schedtune.boost" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/foreground/schedtune.preferidle` > /dev/stune/foreground/schedtune.preferidle" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/top-app/schedtune.boost` > /dev/stune/top-app/schedtune.boost" >> $BACKUP;
        $BB echo "echo `cat /dev/stune/top-app/schedtune.preferidle` > /dev/stune/top-app/schedtune.preferidle" >> $BACKUP;

        echo " TDP Performance Booster ---"
        settings put system min_refresh_rate 60.0
        settings put system previous_ram_expand_size 0
        settings put secure long_press_timeout 250
        settings put secure multi_press_timeout 250
        settings put global accessibility_reduce_transparency 1
        settings put global ram_expand_size 0

        # Lower Schedtune on background as it will consume quite a lot of power.
        $BB echo 2 > /dev/stune/background/schedtune.boost
        $BB echo 1 > /dev/stune/background/schedtune.preferidle

        # Slightly increase the number for Schedtune on Foreground appa to get a better experience.
        $BB echo 8 > /dev/stune/foreground/schedtune.boost
        $BB echo 0 > /dev/stune/foreground/schedtune.preferidle
        
        # Top-app is an app that is used frequently, so increasing the number will get more performance.
        $BB echo 25 > /dev/stune/top-app/schedtune.boost
        $BB echo 0 > /dev/stune/top-app/schedtune.preferidle


    fi;

    # Display Tweaks
    if [[ "$(grep -ic display $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the original settings to the backup
        $BB echo "settings put system accelerometer_rotation `settings get system accelerometer_rotation`" >> $BACKUP;
        $BB echo "settings put system auto_screen_on `settings get system auto_screen_on`" >> $BACKUP;
        $BB echo "settings put system blue_light_filter `settings get system blue_light_filter`" >> $BACKUP;
        $BB echo "settings put system blue_light_filter_adaptive_mode `settings get system blue_light_filter_adaptive_mode`" >> $BACKUP;
        $BB echo "settings put system display_night_theme `settings get system display_night_theme`" >> $BACKUP;
        $BB echo "settings put system display_night_theme_wallpaper `settings get system display_night_theme_wallpaper`" >> $BACKUP;
        $BB echo "settings put system screen_mode_automatic_setting `settings get system screen_mode_automatic_setting`" >> $BACKUP;
        $BB echo "settings put system screen_off_pocket `settings get system screen_off_pocket`" >> $BACKUP;

        echo " TDP Display Tweaks ---"
        settings put system accelerometer_rotation 0
        settings delete system auto_screen_on
        settings put system blue_light_filter 0
        settings put system blue_light_filter_adaptive_mode 0
        settings put system display_night_theme 1
        settings put system display_night_theme_wallpaper 0
        settings put system screen_mode_automatic_setting 0
        settings put system screen_off_pocket 0

    fi;

    # tweak some feedback
    if [[ "$(grep -ic feedback $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the original settings to the backup
        $BB echo "settings put system camera_feedback_vibrate `settings get system camera_feedback_vibrate`" >> $BACKUP
        $BB echo "settings put system dialing_keypad_vibrate `settings get system dialing_keypad_vibrate`" >> $BACKUP
        $BB echo "settings put system dtmf_tone `settings get system dtmf_tone`" >> $BACKUP
        $BB echo "settings put system lockscreen_sounds_enabled `settings get system lockscreen_sounds_enabled`" >> $BACKUP
        $BB echo "settings put system navigation_gestures_vibrate `settings get system navigation_gestures_vibrate`" >> $BACKUP
        $BB echo "settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY `settings get system SEM_VIBRATION_FORCE_TOUCH_INTENSITY`" >> $BACKUP
        $BB echo "settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY `settings get system SEM_VIBRATION_NOTIFICATION_INTENSITY`" >> $BACKUP
        $BB echo "settings put system SEM_VIBRATION_RING_INTENSITY `settings get system SEM_VIBRATION_RING_INTENSITY`" >> $BACKUP
        $BB echo "settings put system sound_effects_enabled `settings get system sound_effects_enabled`" >> $BACKUP
        $BB echo "settings put system sync_vibration_with_notification `settings get system sync_vibration_with_notification`" >> $BACKUP
        $BB echo "settings put system sync_vibration_with_ringtone `settings get system sync_vibration_with_ringtone`" >> $BACKUP
        $BB echo "settings put system vibrate_when_ringing `settings get system vibrate_when_ringing`" >> $BACKUP
        $BB echo "settings put system vibration_sound_enabled `settings get system vibration_sound_enabled`" >> $BACKUP
        $BB echo "settings put system VIB_FEEDBACK_MAGNITUDE `settings get system VIB_FEEDBACK_MAGNITUDE`" >> $BACKUP
        $BB echo "settings put system VIB_RECVCALL_MAGNITUDE `settings get system VIB_RECVCALL_MAGNITUDE`" >> $BACKUP
        $BB echo "settings put secure charging_sounds_enabled `settings get secure charging_sounds_enabled`" >> $BACKUP
        $BB echo "settings put secure charging_vibration_enabled `settings get secure charging_vibration_enabled`" >> $BACKUP
        $BB echo "settings put global dock_sounds_enabled `settings get global dock_sounds_enabled`" >> $BACKUP
        $BB echo "settings put global emergency_tone `settings get global emergency_tone`" >> $BACKUP
        $BB echo "settings put global power_sounds_enabled `settings get global power_sounds_enabled`" >> $BACKUP

        echo " TDP Feedback Tweaks Booster ---"
        settings put system camera_feedback_vibrate 0
        settings put system dialing_keypad_vibrate 0
        settings put system dtmf_tone 0
        settings put system lockscreen_sounds_enabled 0
        settings put system navigation_gestures_vibrate 0
        settings put system SEM_VIBRATION_FORCE_TOUCH_INTENSITY 0
        settings put system SEM_VIBRATION_NOTIFICATION_INTENSITY 5
        settings put system SEM_VIBRATION_RING_INTENSITY 5
        settings put system sound_effects_enabled 0
        settings put system sync_vibration_with_notification 1
        settings put system sync_vibration_with_ringtone 1
        settings put system vibrate_when_ringing 1
        settings put system vibration_sound_enabled 0
        settings put system VIB_FEEDBACK_MAGNITUDE 0
        settings put system VIB_RECVCALL_MAGNITUDE 5
        settings put secure charging_sounds_enabled 0
        settings put secure charging_vibration_enabled 0
        settings put global dock_sounds_enabled 0
        settings put global emergency_tone 0
        settings put global power_sounds_enabled 0

    fi;

    # tweak some gestures
    if [[ "$(grep -ic gesture $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the original settings to the backup
        $BB echo "settings put system mcf_continuity `settings get system mcf_continuity`" >> $BACKUP
        $BB echo "settings put system master_motion `settings get system master_motion`" >> $BACKUP
        $BB echo "settings put system motion_engine `settings get system motion_engine`" >> $BACKUP
        $BB echo "settings put system motion_pick_up `settings get system motion_pick_up`" >> $BACKUP
        $BB echo "settings put system air_motion_engine `settings get system air_motion_engine`" >> $BACKUP
        $BB echo "settings put system air_motion_wake_up `settings get system air_motion_wake_up`" >> $BACKUP
        $BB echo "settings put secure adaptive_sleep `settings get secure adaptive_sleep`" >> $BACKUP
        $BB echo "settings put secure aware_enabled `settings get secure aware_enabled`" >> $BACKUP
        $BB echo "settings put secure back_gesture_inset_scale_left `settings get secure back_gesture_inset_scale_left`" >> $BACKUP
        $BB echo "settings put secure back_gesture_inset_scale_right `settings get secure back_gesture_inset_scale_right`" >> $BACKUP
        $BB echo "settings put secure emergency_gesture_enabled `settings get secure emergency_gesture_enabled`" >> $BACKUP
        $BB echo "settings put secure hush_gesture_used `settings get secure hush_gesture_used`" >> $BACKUP
        $BB echo "settings put secure silence_gesture `settings get secure silence_gesture`" >> $BACKUP
        $BB echo "settings put secure skip_gesture `settings get secure skip_gesture`" >> $BACKUP
        $BB echo "settings put secure volume_hush_gesture `settings get secure volume_hush_gesture`" >> $BACKUP
        $BB echo "settings put global ambient_enabled `settings get global ambient_enabled`" >> $BACKUP
        $BB echo "settings put global ambient_tilt_to_wake `settings get global ambient_tilt_to_wake`" >> $BACKUP
        $BB echo "settings put global ambient_touch_to_wake `settings get global ambient_touch_to_wake`" >> $BACKUP
        $BB echo "settings put global enable_back_animation `settings get global enable_back_animation`" >> $BACKUP

        echo " TDP Gesture Tweaks ---"
        settings put system mcf_continuity 0
        settings put system master_motion 0
        settings put system motion_engine 0
        settings put system motion_pick_up 0
        settings put system air_motion_engine 0
        settings put system air_motion_wake_up 0
        settings put secure adaptive_sleep 0
        settings put secure aware_enabled 0
        settings put secure back_gesture_inset_scale_left 0.75
        settings put secure back_gesture_inset_scale_right 0.75
        settings put secure emergency_gesture_enabled 0
        settings put secure hush_gesture_used 0
        settings put secure silence_gesture 0
        settings put secure skip_gesture 0
        settings put secure volume_hush_gesture 0
        settings put global ambient_enabled 0
        settings put global ambient_tilt_to_wake 0
        settings put global ambient_touch_to_wake 0
        settings put global enable_back_animation 0

    fi;

    # tweak a few google services
    if [[ "$(grep -ic googleservice $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the backup settings
        $BB echo "settings put system direct_share `settings get system direct_share`" >> $BACKUP;
        $BB echo "settings put system gearhead:driving_mode_settings_enabled `settings get system gearhead:driving_mode_settings_enabled`" >> $BACKUP;
        $BB echo "settings put secure smartspace `settings get secure smartspace`" >> $BACKUP;
        $BB echo "settings put global google_core_control `settings get global google_core_control`" >> $BACKUP;

        echo " TDP Google Service Tweaks ---"
        settings put system direct_share 0
        settings put system gearhead:driving_mode_settings_enabled 0
        settings put secure smartspace 0
        settings put global google_core_control 0

    fi;

    # tweak the lockscreen
    if [[ "$(grep -ic lockscreen $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the backup settings
        $BB echo "settings put system add_info_alarm `settings get system add_info_alarm`" >> $BACKUP
        $BB echo "settings put system add_info_today_schedule `settings get system add_info_today_schedule`" >> $BACKUP
        $BB echo "settings put system add_info_music_control `settings get system add_info_music_control`" >> $BACKUP
        $BB echo "settings put system facewidget_music_transparency `settings get system facewidget_music_transparency`" >> $BACKUP
        $BB echo "settings put system lockstar_enabled `settings get system lockstar_enabled`" >> $BACKUP
        $BB echo "settings put system lock_editor_support_touch_hold `settings get system lock_editor_support_touch_hold`" >> $BACKUP
        $BB echo "settings put system lock_noticard_opacity `settings get system lock_noticard_opacity`" >> $BACKUP
        $BB echo "settings put system screen_transition_effect `settings get system screen_transition_effect`" >> $BACKUP
        $BB echo "settings put secure lock_screen_show_notifications `settings get secure lock_screen_show_notifications`" >> $BACKUP
        $BB echo "settings put secure lock_screen_lock_after_timeout `settings get secure lock_screen_lock_after_timeout`" >> $BACKUP
        $BB echo "settings put secure lock_screen_owner_info_enabled `settings get secure lock_screen_owner_info_enabled`" >> $BACKUP

        echo " TDP Lockscreen Tweaks ---"
        settings put system add_info_alarm 0
        settings put system add_info_today_schedule 0
        settings put system add_info_music_control 1
        settings put system facewidget_music_transparency 0
        settings delete system lockstar_enabled
        settings put system lock_editor_support_touch_hold 0
        settings put system lock_noticard_opacity 0
        settings put system screen_transition_effect 0
        settings put secure lock_screen_show_notifications 1
        settings put secure lock_screen_lock_after_timeout 0
        settings put secure lock_screen_owner_info_enabled 1

    fi;

    # tweak our networking and telephony a bit
    if [[ "$(grep -ic telephony $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the backup settings
        $BB echo "settings put system call_answer_vib `settings get system call_answer_vib`" >> $BACKUP;
        $BB echo "settings put system call_end_vib `settings get system call_end_vib`" >> $BACKUP;
        $BB echo "settings put system call_extra_volume `settings get system call_extra_volume`" >> $BACKUP;
        $BB echo "settings put system call_noise_reduction `settings get system call_noise_reduction`" >> $BACKUP;
        $BB echo "settings put system call_popup `settings get system call_popup`" >> $BACKUP;
        $BB echo "settings put system display_caller_info_card `settings get system display_caller_info_card`" >> $BACKUP;
        $BB echo "settings put system select_icon_1 `settings get system select_icon_1`" >> $BACKUP;
        $BB echo "settings put system select_name_1 `settings get system select_name_1`" >> $BACKUP;
        $BB echo "settings put secure data_preferred_mode_during_calling `settings get secure data_preferred_mode_during_calling`" >> $BACKUP;
        $BB echo "settings put global ble_scan_always_enabled `settings get global ble_scan_always_enabled`" >> $BACKUP;
        $BB echo "settings put global default_restrict_background_data `settings get global default_restrict_background_data`" >> $BACKUP;
        $BB echo "settings put global mobile_signal_detector `settings get global mobile_signal_detector`" >> $BACKUP;
        $BB echo "settings put global network_recommendations_enabled `settings get global network_recommendations_enabled`" >> $BACKUP;
        $BB echo "settings put global network_scoring_ui_enabled `settings get global network_scoring_ui_enabled`" >> $BACKUP;
        $BB echo "settings put global select_icon_1 `settings get global select_icon_1`" >> $BACKUP;
        $BB echo "settings put global select_name_1 `settings get global select_name_1`" >> $BACKUP;
        $BB echo "settings put global swipe_to_call_message `settings get global swipe_to_call_message`" >> $BACKUP;

        echo " TDP Telephony Tweaks ---"
        settings put system call_answer_vib 1
        settings put system call_end_vib 1
        settings put system call_extra_volume 1
        settings put system call_noise_reduction 1
        settings put system call_popup 1
        settings put system display_caller_info_card 1
        settings put system select_icon_1 4
        settings put system select_name_1 SWITCH
        settings put secure data_preferred_mode_during_calling 1
        settings put global ble_scan_always_enabled 0
        settings delete global default_restrict_background_data
        settings put global mobile_signal_detector 0
        settings put global network_recommendations_enabled 0
        settings put global network_scoring_ui_enabled 0
        settings put global select_icon_1 4
        settings put global select_name_1 SWITCH
        settings put global swipe_to_call_message 0

    fi;

    # disable the screensaver
    if [[ "$(grep -ic screensaver $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put secure screensaver_enabled `settings get secure screensaver_enabled`" >> $BACKUP;
        $BB echo "settings put secure screensaver_activate_on_sleep `settings get secure screensaver_activate_on_sleep`" >> $BACKUP;
        $BB echo "settings put secure screensaver_activate_on_dock `settings get secure screensaver_activate_on_dock`" >> $BACKUP;

        echo " TDP Screensaver Tweaks ---"
        settings put secure screensaver_enabled 0
        settings put secure screensaver_activate_on_sleep 0
        settings put secure screensaver_activate_on_dock 0

    fi;

    # tweak some system settings
    if [[ "$(grep -ic settings $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put system access_control_enabled `settings get system access_control_enabled`" >> $BACKUP;
        $BB echo "settings put system android.wallpaper.settings_systemui_transparency `settings get system android.wallpaper.settings_systemui_transparency`" >> $BACKUP;
        $BB echo "settings put system Flashlight_brightness_level `settings get system Flashlight_brightness_level 1001`" >> $BACKUP;
        $BB echo "settings put system nearby_scanning_enabled `settings get system nearby_scanning_enabled`" >> $BACKUP;
        $BB echo "settings put system people_stripe `settings get system people_stripe`" >> $BACKUP;
        $BB echo "settings put system security_policy_update `settings get system security_policy_update`" >> $BACKUP;
        $BB echo "settings put system send_security_reports `settings get system send_security_reports`" >> $BACKUP;
        $BB echo "settings put secure backup_enabled `settings get secure backup_enabled`" >> $BACKUP;
        $BB echo "settings put secure clipboard_show_access_notifications `settings get secure clipboard_show_access_notifications`" >> $BACKUP;
        $BB echo "settings put secure notification_badging `settings get secure notification_badging`" >> $BACKUP;
        $BB echo "settings put secure notification_bubbles `settings get secure notification_bubbles`" >> $BACKUP;
        $BB echo "settings put secure show_notification_snooze `settings get secure show_notification_snooze`" >> $BACKUP;
        $BB echo "settings put secure spell_checker_enabled `settings get secure spell_checker_enabled`" >> $BACKUP;
        $BB echo "settings put secure user_full_data_backup_aware `settings get secure user_full_data_backup_aware`" >> $BACKUP;
        $BB echo "settings put global assisted_gps_enabled `settings get global assisted_gps_enabled`" >> $BACKUP;
        $BB echo "settings put global bug_report `settings get global bug_report`" >> $BACKUP;
        $BB echo "settings put global master_sync_status `settings get global master_sync_status`" >> $BACKUP;
        $BB echo "settings put global retail_mode `settings get global retail_mode`" >> $BACKUP;
        $BB echo "settings put global screen_call `settings get global screen_call`" >> $BACKUP;
        $BB echo "settings put global send_action_app_error `settings get global send_action_app_error`" >> $BACKUP;
        $BB echo "settings put global uwb_enabled `settings get global uwb_enabled`" >> $BACKUP;
        $BB echo "settings put global wait_for_debugger `settings get global wait_for_debugger`" >> $BACKUP;

        echo " TDP Settings Tweaks ---"
        settings put system access_control_enabled 0
        settings put system android.wallpaper.settings_systemui_transparency 0
        settings put system Flashlight_brightness_level 1001
        settings put system nearby_scanning_enabled 0
        settings put system people_stripe 0
        settings put system security_policy_update 1
        settings put system send_security_reports 0
        settings put secure backup_enabled 1
        settings put secure clipboard_show_access_notifications 1
        settings put secure notification_badging 0
        settings put secure notification_bubbles 0
        settings put secure show_notification_snooze 1
        settings put secure spell_checker_enabled 1
        settings put secure user_full_data_backup_aware 1
        settings put global assisted_gps_enabled 1
        settings put global bug_report 0
        settings put global master_sync_status 1
        settings put global retail_mode 0
        settings put global screen_call 0
        settings delete global send_action_app_error
        settings put global uwb_enabled 0
        settings put global wait_for_debugger 0

    fi;

    # tweak security a tad
    if [[ "$(grep -ic security $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put secure multi_control_connection_state `settings get secure multi_control_connection_state`" >> $BACKUP;
        $BB echo "settings put secure wifi_adps_enable `settings get secure wifi_adps_enable`" >> $BACKUP;
        $BB echo "settings put secure tap_duration_threshold `settings get secure tap_duration_threshold`" >> $BACKUP;
        $BB echo "settings put secure touch_blocking_period `settings get secure touch_blocking_period`" >> $BACKUP;

        echo " TDP Security Tweaks ---"
        settings put secure multi_control_connection_state 0
        settings delete secure wifi_adps_enable
        settings put secure tap_duration_threshold 0
        settings put secure touch_blocking_period 0

    fi;

    # you don't need to autoconnect do you?
    if [[ "$(grep -ic wifi $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put global auto_wifi `settings get global auto_wifi`" >> $BACKUP;
        $BB echo "settings put global sem_wifi_network_rating_scorer_enabled `settings get global sem_wifi_network_rating_scorer_enabled`" >> $BACKUP;
        $BB echo "settings put global sem_wifi_switch_to_better_wifi_enabled `settings get global sem_wifi_switch_to_better_wifi_enabled`" >> $BACKUP;
        $BB echo "settings put global sem_wifi_switch_to_better_wifi_supported `settings get global sem_wifi_switch_to_better_wifi_supported`" >> $BACKUP;
        $BB echo "settings put global wifi_networks_available_notification_on `settings get global wifi_networks_available_notification_on`" >> $BACKUP;
        $BB echo "settings put global wifi_scan_always_enabled `settings get global wifi_scan_always_enabled`" >> $BACKUP;

        echo " TDP Wifi Tweaks ---"
        settings put global auto_wifi 0
        settings put global sem_wifi_network_rating_scorer_enabled 0
        settings put global sem_wifi_switch_to_better_wifi_enabled 0
        settings put global sem_wifi_switch_to_better_wifi_supported 0
        settings put global wifi_networks_available_notification_on 0
        settings put global wifi_scan_always_enabled 0

    fi;

    # disable the global package verifier
    if [[ "$(grep -ic packageverifier $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put global package_verifier_user_consent `settings get global package_verifier_user_consent`" >> $BACKUP; 

        echo " TDP Package Verifier Tweaks ---"
        settings put global package_verifier_user_consent 0

    fi;

    # tweak the location services a bit
    if [[ "$(grep -ic location $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put secure masterLocationPackagePrefixBlacklist `settings get secure masterLocationPackagePrefixBlacklist`" >> $BACKUP;
        $BB echo "settings put secure masterLocationPackagePrefixWhitelist `settings get secure masterLocationPackagePrefixWhitelist`" >> $BACKUP;
        $BB echo "settings put system location_ignore_settings_package_whitelist `settings get system location_ignore_settings_package_whitelist`" >> $BACKUP;
        $BB echo "settings put secure location_ignore_settings_package_whitelist `settings get secure location_ignore_settings_package_whitelist`" >> $BACKUP;
        $BB echo "settings put global location_ignore_settings_package_whitelist `settings get global location_ignore_settings_package_whitelist`" >> $BACKUP;

        echo " TDP Location Tweaks ---"
        settings delete secure masterLocationPackagePrefixBlacklist
        settings delete secure masterLocationPackagePrefixWhitelist
        settings delete system location_ignore_settings_package_whitelist
        settings delete secure location_ignore_settings_package_whitelist
        settings delete global location_ignore_settings_package_whitelist

    fi;

    # Set animation scales
    if [[ "$(grep -ic animation $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "settings put global window_animation_scale `settings get global window_animation_scale`" >> $BACKUP
        $BB echo "settings put global transition_animation_scale `settings get global transition_animation_scale`" >> $BACKUP
        $BB echo "settings put global animator_duration_scale `settings get global animator_duration_scale`" >> $BACKUP
        $BB echo "echo `cat /dev/stune/schedtune.boost` > /dev/stune/schedtune.boost" >> $BACKUP
        $BB echo "echo `cat /dev/stune/schedtune.preferidle` > /dev/stune/schedtune.preferidle" >> $BACKUP

        echo " TDP Animation Scale Tweaks ---"
        settings put global window_animation_scale 0.25
        settings put global transition_animation_scale 0.25
        settings put global animator_duration_scale 0.25

        # Change the value Schedtune.boost to get smoothness UI/UX and responsiveness touch
        $BB echo 7 > /dev/stune/schedtune.boost
        $BB echo 1 > /dev/stune/schedtune.preferidle

    fi;

    # restrict abusive apps
    if [[ "$(grep -ic abusiveapps $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "device_config put activity_manager bg_auto_restrict_abusive_apps `device_config get activity_manager bg_auto_restrict_abusive_apps`" >> $BACKUP;
        $BB echo "device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled `device_config get activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled`" >> $BACKUP;

        echo " TDP Restrict Abusive Apps ---"
        device_config put activity_manager bg_auto_restrict_abusive_apps 1
        device_config put activity_manager bg_current_drain_auto_restrict_abusive_apps_enabled 1

    fi;

    # disable well being background jobs
    if [[ "$(grep -ic wellbeing $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "pm enable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService" >> $BACKUP;
        $BB echo "pm enable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService" >> $BACKUP;

        echo " TDP Wellbeing Background Job Tweaks ---"
        pm disable com.google.android.apps.wellbeing/.powerstate.impl.PowerStateJobService
        pm disable com.google.android.apps.wellbeing/androidx.work.impl.background.systemjob.SystemJobService

    fi;

    # tweak the network, much thanks to @zaidannn7
    if [[ "$(grep -ic network $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write out the original settings
        $BB echo "echo `cat /proc/sys/net/core/wmem_max` > /proc/sys/net/core/wmem_max" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/core/rmem_max` > /proc/sys/net/core/rmem_max" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/core/rmem_default` > /proc/sys/net/core/rmem_default" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/core/wmem_default` > /proc/sys/net/core/wmem_default" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_timestamps` > /proc/sys/net/ipv4/tcp_timestamps" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_tw_reuse` > /proc/sys/net/ipv4/tcp_tw_reuse" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_sack` > /proc/sys/net/ipv4/tcp_sack" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_tw_recycle` > /proc/sys/net/ipv4/tcp_tw_recycle" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_window_scaling` > /proc/sys/net/ipv4/tcp_window_scaling" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_keepalive_probes` > /proc/sys/net/ipv4/tcp_keepalive_probes" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_keepalive_intvl` > /proc/sys/net/ipv4/tcp_keepalive_intvl" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_fin_timeout` > /proc/sys/net/ipv4/tcp_fin_timeout" >> $BACKUP;
        $BB echo "echo '`cat /proc/sys/net/ipv4/tcp_wmem`' > /proc/sys/net/ipv4/tcp_wmem" >> $BACKUP;
        $BB echo "echo '`cat /proc/sys/net/ipv4/tcp_mem`' > /proc/sys/net/ipv4/tcp_mem" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_ecn` > /proc/sys/net/ipv4/tcp_ecn" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_fastopen` > /proc/sys/net/ipv4/tcp_fastopen" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/net/ipv4/tcp_syncookies` > /proc/sys/net/ipv4/tcp_syncookies" >> $BACKUP;

        echo " TDP Networking Tweaks ---"
        $BB echo 404480 > /proc/sys/net/core/wmem_max
        $BB echo 404480 > /proc/sys/net/core/rmem_max
        $BB echo 256960 > /proc/sys/net/core/rmem_default
        $BB echo 256960 > /proc/sys/net/core/wmem_default
        $BB echo 0 > /proc/sys/net/ipv4/tcp_timestamps
        $BB echo 1 > /proc/sys/net/ipv4/tcp_tw_reuse
        $BB echo 1 > /proc/sys/net/ipv4/tcp_sack
        $BB echo 1 > /proc/sys/net/ipv4/tcp_tw_recycle
        $BB echo 1 > /proc/sys/net/ipv4/tcp_window_scaling
        $BB echo 5 > /proc/sys/net/ipv4/tcp_keepalive_probes
        $BB echo 30 > /proc/sys/net/ipv4/tcp_keepalive_intvl
        $BB echo 30 > /proc/sys/net/ipv4/tcp_fin_timeout
        $BB echo "262144 524288 8388608" > /proc/sys/net/ipv4/tcp_wmem
        $BB echo "262144 524288 8388608" > /proc/sys/net/ipv4/tcp_mem
        $BB echo 1 > /proc/sys/net/ipv4/tcp_ecn
        $BB echo 3 > /proc/sys/net/ipv4/tcp_fastopen
        $BB echo 0 > /proc/sys/net/ipv4/tcp_syncookies

    fi;

    # tweak the filesystems
    if [[ "$(grep -ic filesystem $MODDIR/tdp-settings)" -ge 1 ]]; then

        # write the current configurations to the backup
        for queue in /sys/block/*/queue; do
            $BB echo "echo `cat $queue/iostats` > $queue/iostats" >> $BACKUP;
            $BB echo "echo `cat $queue/read_ahead_kb` > $queue/read_ahead_kb" >> $BACKUP;
            $BB echo "echo `cat $queue/nr_requests` > $queue/nr_requests" >> $BACKUP;
        done
        $BB echo "echo `cat /proc/sys/fs/dir-notify-enable` > /proc/sys/fs/dir-notify-enable" >> $BACKUP;
        $BB echo "echo `cat /proc/sys/fs/by-name/userdata/iostat_enable` > /proc/sys/fs/by-name/userdata/iostat_enable" >> $BACKUP;

        echo " TDP Filesystem Tweaks ---"

        # tweak the queues for each attached block device
        for queue in /sys/block/*/queue; do
            $BB echo 0 > $queue/iostats
            $BB echo 128 > $queue/read_ahead_kb
            $BB echo 64 > $queue/nr_requests
        done

        # turn off notifications and i/o stats
        $BB echo 0 > /proc/sys/fs/dir-notify-enable
        $BB echo 0 > /proc/sys/fs/by-name/userdata/iostat_enable

    fi;

    echo `date`;
    echo " --- Ending TDP Settings Tweaks ---"

    # make this script sleep for 8 hours
    sleep 8h

done
) &
