#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/kernel.bak

    # we need to get all these settings and echo them out to our backup
    $BB echo "echo `cat /sys/kernel/mm/lru_gen/enabled` > /sys/kernel/mm/lru_gen/enabled" >> $BACKUP;
    $BB echo "echo `cat /sys/kernel/mm/lru_gen/min_ttl_ms` > /sys/kernel/mm/lru_gen/min_ttl_ms" >> $BACKUP;
    $BB echo "echo `cat /sys/module/dm_bufio/parameters/max_cache_size_bytes` > /sys/module/dm_bufio/parameters/max_cache_size_bytes" >> $BACKUP;
    $BB echo "echo `cat /sys/module/dm_bufio/parameters/peak_allocated_bytes` > /sys/module/dm_bufio/parameters/peak_allocated_bytes" >> $BACKUP;
    $BB echo "echo `cat /sys/module/fuse/parameters/max_user_bgreq` > /sys/module/fuse/parameters/max_user_bgreq" >> $BACKUP;
    $BB echo "echo `cat /sys/module/fuse/parameters/max_user_congthresh` > /sys/module/fuse/parameters/max_user_congthresh" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/sched_migration_cost_ns`' > /proc/sys/kernel/sched_migration_cost_ns" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/sched_child_runs_first`' > /proc/sys/kernel/sched_child_runs_first" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/sched_autogroup_enabled`' > /proc/sys/kernel/sched_autogroup_enabled" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/sched_tunable_scaling`' > /proc/sys/kernel/sched_tunable_scaling" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/hung_task_timeout_secs`' > /proc/sys/kernel/hung_task_timeout_secs" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/perf_cpu_time_max_percent`' > /proc/sys/kernel/perf_cpu_time_max_percent" >> $BACKUP;
    $BB echo "echo '`cat /proc/sys/kernel/timer_migration`' > /proc/sys/kernel/timer_migration" >> $BACKUP;
    $BB echo "echo `cat /proc/sys/kernel/sched_schedstats` > /proc/sys/kernel/sched_schedstats" >> $BACKUP;

    echo `date`;
    echo " --- Starting TDP Kernel Tweaks ---"

    echo " TDP Tweaks Fired - LRU Cache Tweaks"
    $BB echo y > /sys/kernel/mm/lru_gen/enabled
    $BB echo 5000 > /sys/kernel/mm/lru_gen/min_ttl_ms

    echo " TDP Tweaks Fired - Cache Tweaks"
    $BB echo 120770560 > /sys/module/dm_bufio/parameters/max_cache_size_bytes
    $BB echo 40079360 > /sys/module/dm_bufio/parameters/peak_allocated_bytes
    $BB echo 1022 > /sys/module/fuse/parameters/max_user_bgreq
    $BB echo 1022 > /sys/module/fuse/parameters/max_user_congthresh

    # some scheduler tweaks
    $BB echo 5000000 > /proc/sys/kernel/sched_migration_cost_ns
    $BB echo 1 > /proc/sys/kernel/sched_child_runs_first
    $BB echo 1 > /proc/sys/kernel/sched_autogroup_enabled
    $BB echo 0 > /proc/sys/kernel/sched_tunable_scaling
    $BB echo 0 > /proc/sys/kernel/hung_task_timeout_secs
    $BB echo 5 > /proc/sys/kernel/perf_cpu_time_max_percent
    $BB echo 1 > /proc/sys/kernel/timer_migration

    # turn off scheduler stats
    $BB echo 0 > /proc/sys/kernel/sched_schedstats

    echo `date`;
    echo " --- Ending TDP Kernel Tweaks ---"

    # make this script sleep for 4 hours
    sleep 8h

done
) & 
