#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# make this run in the background
(
while true
do

    # hold the backup file
    BACKUP=$BACKUPDIR/debugging.bak

    # write out backup
    for i in 'debug_mask' 'log_level*' 'debug_level*' '*debug_mode' 'edac_mc_log*' 'enable_event_log' '*log_level*' '*log_ue*' '*log_ce*' 'log_ecn_error' 'snapshot_crashdumper' 'seclog*' 'compat-log' '*log_enabled' 'tracing_on' 'mballoc_debug'; do
        for o in $(find /sys/ -type f -name "$i"); do

            # turn it off!    
            $BB echo "echo `cat $o` > $o" >> $BACKUP
        
        done
    done
    $BB echo "echo '`cat /proc/sys/kernel/printk`' > /proc/sys/kernel/printk" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/cpu` > /sys/module/printk/parameters/cpu" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/console_suspend` > /sys/module/printk/parameters/console_suspend" >> $BACKUP
    $BB echo "echo `cat /sys/kernel/printk_mode/printk_mode` > /sys/kernel/printk_mode/printk_mode" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/ignore_loglevel` > /sys/module/printk/parameters/ignore_loglevel" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/pid` > /sys/module/printk/parameters/pid" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/time` > /sys/module/printk/parameters/time" >> $BACKUP
    $BB echo "echo `cat /sys/module/printk/parameters/printk_ratelimit` > /sys/module/printk/parameters/printk_ratelimit" >> $BACKUP
    $BB echo "echo `cat /proc/sys/kernel/printk_devkmsg` > /proc/sys/kernel/printk_devkmsg" >> $BACKUP

    echo `date`;
    echo " --- Starting TDP Debugging Disabler ---"

    # Loop over known debugging services
    for i in 'logcat' 'logcatd' 'logd' 'tcpdump' 'cnss_diag' 'statsd' 'traced' 'idd-logreader' 'idd-logreadermain' 'stats' 'dumpstate' 'aplogd'; do

        # kill them... now!
        $BB killall -9 $i;

    done;

    # Kernel Debugging (thx to KTSR)
    for i in 'debug_mask' 'log_level*' 'debug_level*' '*debug_mode' 'edac_mc_log*' 'enable_event_log' '*log_level*' '*log_ue*' '*log_ce*' 'log_ecn_error' 'snapshot_crashdumper' 'seclog*' 'compat-log' '*log_enabled' 'tracing_on' 'mballoc_debug'; do
        for o in $(find /sys/ -type f -name "$i"); do

            # turn it off!    
            $BB echo 0 > $o
        
        done
    done

    # Printk (thx to KNTD-reborn)
    $BB echo '0 0 0 0' > /proc/sys/kernel/printk
    $BB echo 0 > /sys/module/printk/parameters/cpu
    $BB echo 1 > /sys/module/printk/parameters/console_suspend
    $BB echo 0 > /sys/kernel/printk_mode/printk_mode
    $BB echo 1 > /sys/module/printk/parameters/ignore_loglevel
    $BB echo 0 > /sys/module/printk/parameters/pid
    $BB echo 0 > /sys/module/printk/parameters/time
    $BB echo 0 > /sys/module/printk/parameters/printk_ratelimit
    $BB echo off > /proc/sys/kernel/printk_devkmsg

    echo `date`;
    echo " --- Ending TDP Debugging Disabler ---"

    # make this script sleep for 4 hours
    sleep 4h

done
) & 
