#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(

    # hold the backup file
    BACKUP=$BACKUPDIR/compiler.bak

    # check if it's already been run
    if [[ -f "$MODDIR/.compilerran" ]]; then

        # start logging if enabled
        echo `date`;
        echo " --- Compiler has already run and will not be run again ---"

    else

        # start logging if enabled
        echo `date`;
        echo " --- Starting TDP Compiler ---"

        # make sure we check to see if we're beyond A13 or before it.
        if [[ "$(getprop ro.build.version.release)" -lt "14" ]]; then

            # attempt to do a full jit compile of all packages without checking the package profile
            # this is for battery life improvment
            pm compile -a -f --check-prof false -m everything

            # attempt to do a full jit compile of all package layouts without checking the package profile
            # this is for battery life improvment
            pm compile -a -f --check-prof false --compile-layouts

            # the above may break some apps.  To undo it run: `pm compile -a -f -r install` in shell or adb shell

            # write the undo compiler to the backup
            $BB echo "pm compile -a -f -r install;" >> $BACKUP

        else

            echo " Your device is over Android 13, no need for the compiler ---"

        fi;

        # finishes optimizing all system pakages for battery
        pm bg-dexopt-job

        # make sure the already ran flag is set
        touch $MODDIR/.compilerran;

        echo `date`;
        echo " --- Ending TDP Compiler ---"

    fi;

    # if the uncompiler exists
    if [[ -f "$MODDIR/tdp-undocompile" ]]; then

        # make sure we check to see if we're beyond A13 or before it.
        if [[ "$(getprop ro.build.version.release)" -lt "14" ]]; then

            # undo the battery compilation
            pm compile -a -f -r install

        fi;

        # now make sure the already ran flag is set
        touch $MODDIR/.compilerran;

        # and remove this uncompiler flag
        rm -f $MODDIR/tdp-undocompile;

    fi;

) &
