#!/system/bin/sh

# we're going to wait until the boot has completed
while [ "$(/system/bin/getprop sys.boot_completed)" != 1 ]
do
    sleep 1
done

# run the entire bit in the background
(
while true
do

    # start logging if enabled
    echo `date`;
    echo " --- Starting TDP Memory Holder ---"

    # Get a list of packages, uniquely sorted
    PACKAGES=$(cmd package list packages -f | sed -e 's/.*=//' | uniq | sort);

    # hold the package string, by default we're adding: com.android.systemui & com.android.launcher
    HELDPKGS="com.android.systemui,com.android.launcher,"

    # loop over our packages
    for pkg in $PACKAGES; 
    do

        # is this packge in our inclusions?
        if [[ "$(grep -ic "$pkg" $MODDIR/tdp-memory)" -ge 1 ]]; then

            # log it
            echo " Package: $pkg is now held in memory"

            # append it to a string
            HELDPKGS+="$pkg,"

        fi;

    done;

    # set the property to hold the package list in memory
    setprop config.keep.package.name $HELDPKGS;

    echo `date`;
    echo " --- Ending TDP Memory Holder ---"

    # make this script sleep for 8 hours
    sleep 8h

done
) &
